/*****************************
File:       RemoteSFRotation.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteSFRotation.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

#ifdef _WIN32
#include "RemoteSF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

H3DNodeDatabase RemoteSFRotation::database(   
   "RemoteSFRotation", 
   &(newInstance<RemoteSFRotation>),
   typeid(RemoteSFRotation),
   &RemoteField::database);

namespace RemoteSFRotationInternals {   
  FIELDDB_ELEMENT( RemoteSFRotation, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteSFRotation, received, OUTPUT_ONLY );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.


// ----------------------------------------------------------------------------
RemoteSFRotation::RemoteSFRotation()  :
RemoteSF<SFRotation>(H3D::X3DTypes::SFROTATION) {

  type_name = "RemoteSFRotation";
  database.initFields( this );

  received->initialiseValue( Rotation( 0, 0, 0, 0 ) );
}

// ----------------------------------------------------------------------------
void RemoteSFRotation::writeValue (Rotation const & val) {
  writeH3DFloat(val.axis[0]);
  writeH3DFloat(val.axis[1]);
  writeH3DFloat(val.axis[2]);
  writeH3DFloat(val.angle);
}

// ----------------------------------------------------------------------------
void RemoteSFRotation::readValue() {
  Rotation val;
  val.axis[0] = conP->readH3DFloat();
  if (!conP->closeRequested()) {
    val.axis[1] = conP->readH3DFloat();
  }
  if (!conP->closeRequested()) {
    val.axis[2] = conP->readH3DFloat();
  }
  if (!conP->closeRequested()){
    val.angle = conP->readH3DFloat();
  }
  if (!conP->closeRequested()) {
    received->setValue(val, id);
  }
}

