/*****************************
File:       RemoteSFColor.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteSFColor.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

#ifdef _WIN32
#include "RemoteSF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteSFColor::database(   
  "RemoteSFColor", 
  &(newInstance<RemoteSFColor>),
  typeid(RemoteSFColor),
  &RemoteField::database);

namespace RemoteSFColorInternals {   
  FIELDDB_ELEMENT( RemoteSFColor, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteSFColor, received, OUTPUT_ONLY );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.


// ----------------------------------------------------------------------------
RemoteSFColor::RemoteSFColor() :
RemoteSF<SFColor>(H3D::X3DTypes::SFCOLOR)  {

  type_name = "RemoteSFColor";
  database.initFields( this );

  received->initialiseValue( RGB(0.0,0.0,0.0) );
}

// ----------------------------------------------------------------------------
void RemoteSFColor::writeValue (RGB const & val) {
  writeH3DFloat(val.r);
  writeH3DFloat(val.g);
  writeH3DFloat(val.b);
}

// ----------------------------------------------------------------------------
void RemoteSFColor::readValue() {
  RGB val;
  val.r = conP->readH3DFloat();
  if (!conP->closeRequested()) {
    val.g = conP->readH3DFloat();
  }
  if (!conP->closeRequested()) {
    val.b = conP->readH3DFloat();
  }
  if (!conP->closeRequested()) {
    received->setValue(val, id);
  }
}

// ----------------------------------------------------------------------------
void RemoteSFColor::setValue(RGB const & val) {
  received->setValue(val);
}
