/*****************************
File:       RemoteSFBool.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteSFBool.h"
#include "H3DNetworkingUtils/RemoteConnection.h"
#include <H3D/X3DTypes.h>

#ifdef _WIN32
#include "RemoteSF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteSFBool::database(   
   "RemoteSFBool", 
   &(newInstance<RemoteSFBool>),
   typeid(RemoteSFBool),
   &RemoteField::database);

// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.
namespace RemoteSFBoolInternals {   
  FIELDDB_ELEMENT( RemoteSFBool, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteSFBool, received, OUTPUT_ONLY );
}

// ----------------------------------------------------------------------------

RemoteSFBool::RemoteSFBool() :
RemoteSF<SFBool>(H3D::X3DTypes::SFBOOL) {
  type_name = "RemoteSFBool";
  database.initFields( this );

   received->initialiseValue(false);
}

// ----------------------------------------------------------------------------
void RemoteSFBool::readValue() {
   bool val;
   val = readBool();
   if (!conP->closeRequested()) {
       received->setValue(val, id);
   }
}

// ----------------------------------------------------------------------------
void RemoteSFBool::setValue(bool const & val) {
   received->setValue(val, id);
}

