/*****************************
File:       RemoteMFVec3f.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteMFVec3f.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

#ifdef _WIN32
#include "RemoteMF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteMFVec3f::database(   
  "RemoteMFVec3f", 
  &(newInstance<RemoteMFVec3f>),
  typeid(RemoteMFVec3f),
  &RemoteField::database);

namespace RemoteMFVec3fInternals {   
  FIELDDB_ELEMENT( RemoteMFVec3f, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteMFVec3f, received, OUTPUT_ONLY );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.


// ----------------------------------------------------------------------------
RemoteMFVec3f::RemoteMFVec3f() :
RemoteMF<MFVec3f>(H3D::X3DTypes::MFVEC3F) {

   type_name = "RemoteMFVec3f";
   database.initFields( this );

}

// ----------------------------------------------------------------------------
void RemoteMFVec3f::writeValue( vector<H3D::Vec3f> const &val) {
   u_int size = val.size();
   writeInt32(size);
   for (u_int i = 0; i < size; i++) {
      Vec3f v = val[i];
      writeH3DFloat(v.x);
      writeH3DFloat(v.y);
      writeH3DFloat(v.z);
   }
}

// ----------------------------------------------------------------------------
void RemoteMFVec3f::readValue() {
   u_int num = readInt32();
   vector<Vec3f> tmp;
   for (u_int i = 0; i < num; i++) {
      Vec3f val;
      val.x = conP->readH3DFloat();
      if (!conP->closeRequested()) {
         val.y = conP->readH3DFloat();
      }
      if (!conP->closeRequested()) {
         val.z = conP->readH3DFloat();
      }
      if ( !conP->closeRequested() ) {
         tmp.push_back(val);
      }
   }

   if ( !conP->closeRequested() ) {
      received->setValue(tmp, id);
   }
}



