/*****************************
File:       RemoteMFString.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteMFString.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

#ifdef _WIN32
#include "RemoteMF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteMFString::database(   
  "RemoteMFString", 
  &(newInstance<RemoteMFString>),
  typeid(RemoteMFString),
  &RemoteField::database);

namespace RemoteMFStringInternals {   
  FIELDDB_ELEMENT( RemoteMFString, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteMFString, received, OUTPUT_ONLY );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.


// ----------------------------------------------------------------------------
RemoteMFString::RemoteMFString() :
RemoteMF<MFString>(H3D::X3DTypes::MFVEC3F) {

   type_name = "RemoteMFString";
   database.initFields( this );

}

// ----------------------------------------------------------------------------
void RemoteMFString::writeValue( vector<string> const &val) {
   u_int size = val.size();
   writeInt32(size);
   for (u_int i = 0; i < size; i++) {
      string v = val[i];
      writeString(v);
   }
}

// ----------------------------------------------------------------------------
void RemoteMFString::readValue() {
   u_int num = readInt32();
   vector<string> tmp;
   for (u_int i = 0; i < num; i++) {
      string val;
      val = readString();
      if ( !conP->closeRequested() ) {
         tmp.push_back(val);
      }
   }

   if ( !conP->closeRequested() ) {
      received->setValue(tmp, id);
   }
}



