/*****************************
File:       RemoteMFColor.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteMFColor.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

#ifdef _WIN32
#include "RemoteMF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteMFColor::database(   
  "RemoteMFColor", 
  &(newInstance<RemoteMFColor>),
  typeid(RemoteMFColor),
  &RemoteField::database);

namespace RemoteMFColorInternals {   
  FIELDDB_ELEMENT( RemoteMFColor, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteMFColor, received, OUTPUT_ONLY );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.


// ----------------------------------------------------------------------------
RemoteMFColor::RemoteMFColor() :
RemoteMF<MFColor>(H3D::X3DTypes::MFCOLOR) {

   type_name = "RemoteMFColor";
   database.initFields( this );

}

// ----------------------------------------------------------------------------
void RemoteMFColor::writeValue( vector<H3D::RGB> const &val) {
   u_int size = val.size();
   writeInt32(size);
   for (u_int i = 0; i < size; i++) {
      RGB v = val[i];
      writeH3DFloat(v.r);
      writeH3DFloat(v.g);
      writeH3DFloat(v.b);
   }
}

// ----------------------------------------------------------------------------
void RemoteMFColor::readValue() {
   u_int num = readInt32();
   vector<RGB> tmp;
   for (u_int i = 0; i < num; i++) {
      RGB val;
      val.r = conP->readH3DFloat();
      if (!conP->closeRequested()) {
         val.g = conP->readH3DFloat();
      }
      if (!conP->closeRequested()) {
         val.b = conP->readH3DFloat();
      }
      if ( !conP->closeRequested() ) {
         tmp.push_back(val);
      }
   }

   if ( !conP->closeRequested() ) {
      received->setValue(tmp, id);
   }
}



