/*****************************
File:       RemoteCoordPoint.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteCoordPoint.h"

using namespace H3D;
using namespace H3DNetworkingUtils; 
 
#ifdef _WIN32
#include "RemoteNodeField.cpp"
#endif  
  

// ----------------------------------------------------------------------------
RemoteCoordPoint::RemoteCoordPoint() {
  type_name = "RemoteCoordPoint";
  database.initFields( this );
}

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteCoordPoint::database(   
   "RemoteCoordPoint", 
   &(newInstance<RemoteCoordPoint>),
   typeid(RemoteCoordPoint),
   &RemoteNodeField::database);

namespace RemoteCoordPointInternals {   
  FIELDDB_ELEMENT( RemoteCoordPoint, theNode, INPUT_OUTPUT );
  FIELDDB_ELEMENT( RemoteCoordPoint, indexToBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteCoordPoint, indiciesToBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteCoordPoint, sendAll, INPUT_ONLY );
}
// These are really fields of the parent class but because of
// template instantiation conflicting with FIELDDB_ELEMENT they must be included here instead

// ----------------------------------------------------------------------------
void RemoteCoordPoint::writeValue (Vec3f const & val) {
  conP->writeH3DFloat(val.x);
  conP->writeH3DFloat(val.y);
  conP->writeH3DFloat(val.z);
}

// ----------------------------------------------------------------------------
Vec3f RemoteCoordPoint::readVal() {
  Vec3f val;
  val.x = conP->readH3DFloat();
  if (!conP->closeRequested()) {
    val.y = conP->readH3DFloat();
  }
  if (!conP->closeRequested()) {
    val.z = conP->readH3DFloat();
  }
  return val;
}

