/*****************************
File:       RealtimeAttractor.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RealtimeAttractor.h"
#include <H3DNetworkingUtils/threadwrap.h>

using namespace H3D;
using namespace H3DUtil;
using namespace H3DNetworkingUtils;

// -----------------------------------------------------------------------------
H3DNodeDatabase RealtimeAttractor::database(   
  "RealtimeAttractor", 
  &(newInstance<RealtimeAttractor>),
  typeid(RealtimeAttractor),
  &Attractor::database);

namespace RealtimeAttractorInternals {   
  FIELDDB_ELEMENT( RealtimeAttractor, realtimePoint, INPUT_OUTPUT );
}

// -----------------------------------------------------------------------------
RealtimeAttractor::RealtimeAttractor(Inst<LockableSFVec3f> _realtimePoint) :
realtimePoint  (_realtimePoint) {

   type_name = "RealtimeAttractor";
   database.initFields( this );

   realtimePoint->setValue(Vec3f(0.0,0.0,0.0), id);
}

// -----------------------------------------------------------------------------
RealtimeAttractor::~RealtimeAttractor() {
}


// ------------------------------------------------------------
Attractor::AttractForce * RealtimeAttractor::createAttractForce(H3DTime t, 
										 							  Vec3f const & _point,
																	  bool _repel,
																	  H3DFloat _maxForce, 
																	  H3DFloat _maxDeltaForce,
																	  H3DFloat _radius,
																	  H3DFloat _scale,
																	  Vec3f const & _offset) {
	return new RTAttractForce(t, _point, _repel,
                             _maxForce, _maxDeltaForce,
                             _radius, _scale, _offset, this);
}


