/*****************************
File:       MouseHapticDevice.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/MouseHapticDevice.h"
#include <H3D/H3DNavigation.h>
#include <H3D/Sphere.h>
#include <H3D/Shape.h>
#include <H3D/Appearance.h>
#include <H3D/Material.h>

using namespace H3D;
using namespace H3DNetworkingUtils;

// -----------------------------------------------------------
H3DNodeDatabase MouseHapticDevice::database(   
   "MouseHapticDevice", 
   &(newInstance<MouseHapticDevice>),
   typeid(MouseHapticDevice),
   &FakeHapticsDevice::database);

namespace MouseHapticDeviceInternals {   
   FIELDDB_ELEMENT( MouseHapticDevice, mouseSensor, INITIALIZE_ONLY);
   ///FieldDBInsert mouseSensor( INITIALIZE_ONLY( &MouseHapticDevice::database, "field", &MouseHapticDevice::mouseSensor ) );
}

// -----------------------------------------------------------
MouseHapticDevice::MouseHapticDevice(Inst<SFMouseSensor> _mouseSensor) :
mouseSensor (_mouseSensor),
motion_converter (new MouseMotion) {

   motion_converter->route(set_devicePosition);
   
   // To give it a stylus shape of a yellow sphere.
   Shape * shP = new Shape;
   Appearance * appP = new Appearance;
   Material * matP = new Material;
   Sphere * sphP = new Sphere;
   sphP->radius->setValue(0.004f);
   matP->diffuseColor->setValue(RGB(0.9f, 0.9f, 0.0f));
   appP->material->setValue(matP);
   shP->appearance->setValue(appP);
   shP->geometry->setValue(sphP);
   stylus->setValue(shP);
}

// -----------------------------------------------------------
void MouseHapticDevice::initialize() {
   FakeHapticsDevice::initialize();
   H3DNavigation::disableDevice( H3DNavigation::MOUSE );// Can't have it as well
   MouseSensor * msP = mouseSensor->getValue();
   if (msP) {
      msP->middleButton->routeNoEvent(set_mainButton);
      msP->leftButton->route(motion_converter);
      devicePosition->route(motion_converter);
      msP->motion->route(motion_converter);
      msP->rightButton->route(motion_converter);
   }
}

// -----------------------------------------------------------
void MouseHapticDevice::MouseMotion::update() {
   if( H3DNavigation::isEnabled( H3DNavigation::MOUSE ) ) {
     ///H3DNavigation::disableDevice( H3DNavigation::MOUSE ); 
     // We need this here - the one in initialize seems to get overridden somewhere.
   }
   if (routes_in.size() > 3) {
      if (static_cast<SFBool*>(routes_in[0])->getValue()) {
         Vec3f pos = static_cast<SFVec3f*>(routes_in[1])->getValue();
         // They have grabbed it
         Vec2f motion = static_cast<SFVec2f*>(routes_in[2])->getValue();
         if ((motion.x > 100.0f) || (motion.y > 100.0f)) { // Guard against 65534
            return;
         } 
         if ((motion.x < -100.0f) || (motion.y < -100.0f)) { // Guard against 65534
            return;
         } 
         bool z_motion = static_cast<SFBool*>(routes_in[3])->getValue();
         float scale = 0.002f;

         Vec3f temp = pos;
         if (event.ptr == routes_in[2]) {
            //Only do anything if mouse has moved.
            pos.x += motion.x * scale;
            if (z_motion) {
               pos.z += motion.y * scale;
            } else {
               pos.y -= motion.y * scale;
            }
            value = pos;
         } 
      }
   }
}