/*****************************
File:      FilteredSFVec3f.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/FilteredSFVec3f.h"

using namespace H3D;
using namespace H3DNetworkingUtils;

//-----------------------------------------------------------
void FilteredSFVec3f::update() {
  SFVec3f * val = static_cast<SFVec3f *>(routes_in[0]);
  int num_samples = static_cast<SFInt32 *>(routes_in[1])->getValue();

  if (!filterP) {
    // First time
    filterP = new VecFilter(num_samples);
  }
  else if (filterP->sampleSize() != num_samples) {
    filterP->resetValue(num_samples);
  }
  else {
    value = filterP->filter(val->getValue(), event.time_stamp);
  }
}
