/*****************************
File:       Filter.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/Filter.h"

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase Filter::database(   
  "Filter", 
  &(newInstance<Filter>),
  typeid(Filter),
  &X3DChildNode::database);

namespace FilterInternals {   
  FIELDDB_ELEMENT( Filter, rawValue,      INPUT_ONLY );
  FIELDDB_ELEMENT( Filter, filteredValue, INPUT_OUTPUT );
  FIELDDB_ELEMENT( Filter, sampleSize,    INPUT_OUTPUT );
  FIELDDB_ELEMENT( Filter, enabled,       INPUT_OUTPUT );
}

// ----------------------------------------------------------------------------
Filter::Filter(Inst<SFVec3f         > _rawValue,
               Inst<FilteredSFVec3f > _filteredValue,
               Inst<SFInt32         > _samp_size,
               Inst<EnableSwitch    > _enabled ) :
rawValue      (_rawValue),
filteredValue (_filteredValue),
enabled        (_enabled),
sampleSize    (_samp_size) {

  type_name = "Filter";
  database.initFields( this );

  enabled->filtP = this;
  enabled->setValue(true);
  filteredValue->setValue(Vec3f(0,0,0));
  rawValue->setValue(Vec3f(0,0,0));
  rawValue->route(filteredValue);
  sampleSize->setValue(8);
  sampleSize->route(filteredValue);
}
