/*****************************
File:      CollisionSphereHierarchy.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

#include "H3DNetworkingUtils/CollisionSphereHierarchy.h"

using namespace H3D;
using namespace H3DNetworkingUtils;

// -------------------------------------------------
H3DNodeDatabase CollisionSphereHierarchy::database(
  "CollisionSphereHierarchy", 
  &(newInstance<CollisionSphereHierarchy>),
  typeid(CollisionSphereHierarchy),
  &CollisionSphere::database); 

namespace CollidableSphereHierarchyInternals {   
  FIELDDB_ELEMENT( CollisionSphereHierarchy, collidables,       INPUT_OUTPUT ); 
}

// -------------------------------------------
CollisionSphereHierarchy::CollisionSphereHierarchy( 
  Inst< MFCollidableGeometry > _collidables,
  Inst< CollisionSphere::Radius > _radius) :

collidables( _collidables ),
CollisionSphere( _radius) {
   
  type_name = "CollisionSphereHierarchy";
  database.initFields( this );


///  cout << "CollisionSphereHierarchy::CollisionSphereHierarchy" << endl;
  collidables->setOwner(this);
}


// -------------------------------------------
void CollisionSphereHierarchy::initialize() {
  ///for ( MFCollidableGeometry::const_iterator i = collidables->begin(); i != collidables->end(); i++ ) {
  ///  children->push_back(*i);
  ///}
  CollisionSphere::initialize();
}

// -------------------------------------------
void CollisionSphereHierarchy::setDyn( CollidableDynamic *ptr ) {
  CollisionSphere::setDyn(ptr);
  for ( MFCollidableGeometry::const_iterator i = collidables->begin(); i != collidables->end(); i++ ) {
     static_cast<CollisionGeometry*>(*i)->setDyn( ptr );
  }  
}

// -------------------------------------------
void CollisionSphereHierarchy::MFCollidableGeometry::onAdd(Node * n) {
   static_cast<CollisionSphereHierarchy*>(getOwner())->children->push_back(n);
   TypedMFNode< CollisionGeometry >::onAdd(n);
}

// -------------------------------------------
void CollisionSphereHierarchy::MFCollidableGeometry::onRemove(Node * n) {
   static_cast<CollisionSphereHierarchy*>(getOwner())->children->erase(n);
   TypedMFNode< CollisionGeometry >::onRemove(n);
}


