/*****************************
File:      CollisionSphere.cpp
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

#include "H3DNetworkingUtils/CollisionSphere.h"

#include <H3D/Shape.h>
#include <H3D/Appearance.h>
#include <H3D/Material.h>
#include <H3D/Sphere.h>
#include <H3D/RenderProperties.h>

using namespace H3D;
using namespace H3DNetworkingUtils;

// -------------------------------------------------
H3DNodeDatabase CollisionSphere::database(
  "CollisionSphere", 
  &(newInstance<CollisionSphere>),
  typeid(CollisionSphere),
  &CollisionGeometry::database); 

namespace CollidableSphereInternals {   
  FIELDDB_ELEMENT( CollisionSphere, radius,       INITIALIZE_ONLY ); 
  FIELDDB_ELEMENT( CollisionSphere, debug,        INPUT_OUTPUT ); 
}

CollisionSphere::CollisionSphere( Inst< Radius > _radius) :
radius( _radius ),
debug (new SFBool),
scaled_rad_sqrd( 0.0f),
scaled_trans (0,0,0) {
      
   type_name = "CollisionSphere";
   database.initFields( this );

   radius->setOwner(this);
   radius->setValue( 0.01f );
   debug->setValue(false);
  
}

void CollisionSphere::initialize() {
  if (isInitialized()) {
     return;
  }
  CollisionGeometry::initialize();
  rad_sqrd = radius->getValue() * radius->getValue();
  ///scaled_trans = translation->getValue();
  if (debug->getValue()) {
    Shape *shP = new Shape;
    Appearance * appP = new Appearance;
    Sphere * sphP = new Sphere;
    Material * matP = new Material;
    radius->route(sphP->radius);
    shP->appearance->setValue(appP);
    shP->geometry->setValue(sphP);
    appP->material->setValue(matP);
    RGB clr(0,1,0);
    matP->diffuseColor->setValue(clr);
    matP->transparency->setValue(0.7f);
    local_offset->children->push_back(shP); 
  }
}

//--------------------------------------------------
void CollisionSphere::copy(CollisionGeometry * newP) {
  CollisionGeometry::copy(newP);
  CollisionSphere * sphP = dynamic_cast<CollisionSphere*>(newP);
  if (sphP) {
    sphP->radius->setValue(radius->getValue());
  }
}

