/*****************************
File:      CollisionGeometry.cpp
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

#include "H3DNetworkingUtils/CollisionGeometry.h"

using namespace H3D;
using namespace H3DNetworkingUtils;


// -------------------------------------------------
H3DNodeDatabase CollisionGeometry::database(
  "CollisionGeometry", 
  &(newInstance<CollisionGeometry>),
  typeid(CollisionGeometry), NULL);

namespace CollidableGeometryInternals {   
  FIELDDB_ELEMENT( CollisionGeometry, translation,       INITIALIZE_ONLY ); 
  FIELDDB_ELEMENT( CollisionGeometry, rotation,          INITIALIZE_ONLY ); 
  FIELDDB_ELEMENT( CollisionGeometry, matrix,          INPUT_OUTPUT ); 
}

CollisionGeometry::CollisionGeometry( ):
child_local_info (new TransformInfo),
local_offset (new Transform) {
      
   type_name = "CollisionGeometry";
   database.initFields( this );

   children->push_back(local_offset.get());
   local_offset->children->push_back(child_local_info.get());
}


void CollisionGeometry::setDyn( CollidableDynamic *ptr ) {
  collidable_dynamicP = ptr;  // Can't use a AutoRef as it causes a ref() which we
                              // don't want in this casse because it is actually a parent
                              // or a parent of a parent.
}

//--------------------------------------------------
void CollisionGeometry::initialize() {
   Transform::initialize();
   trans = translation->getValue();
}

//--------------------------------------------------
void CollisionGeometry::copy(CollisionGeometry * newP) {
  newP->translation->setValue(translation->getValue());
  newP->rotation->setValue(rotation->getValue());
}

