/*****************************
File:      Thredwrap.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

// The threadwrap class provides an OO interface to threads.

#ifndef _threadwrap_
#define _threadwrap_

#include "H3DNetworkingUtils/Config.h"

/* Distributed under a BSD type license. See the netwrap COPYRIGHT file */

typedef void (* ThreadFunction)(void * arg);

class H3D_NETWORKING_UTILS_DLL_SPEC  Thread {
  protected:
    void * tid; // pthread_t if POSIX, HANDLE if Win32

    static int * priorityMap;	// Converts levels (below) into system values

    virtual void buildPriorityMap ();

  public:
    enum {
         PRI_LOWEST	= 0,
	 PRI_0		= 0,
	 PRI_LOW	= 1,
	 PRI_1		= 1,
	 PRI_NORMAL	= 2,
	 PRI_2		= 2,
	 PRI_HIGH	= 3,
	 PRI_3		= 3,
	 PRI_HIGHEST	= 4,
	 PRI_4		= 4
    };

    // Simple constructor: creates detached standard priority thread
    Thread (ThreadFunction func, void * arg);

    // For more control
    Thread (ThreadFunction func, void * arg, int priority, int autoTerminate);

    virtual ~Thread ();
    
    void * sysRef () { return tid; }

    virtual void wait ();
    virtual void cancel ();

    virtual int getPriority ();
    virtual void setPriority (int newPriority);

    // These ops are static because they must be/are almost always
    // applied only to the current thread

    static void exit ();
    static void sleep (int seconds);
    static void millisleep (int millisecs);
};

#endif
