/*****************************
File:      systypes.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
   Samuel Taylor, (sam.taylor@anu.edu.au)
   Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

// The systypes.h file provides some system type definitions

#ifndef _systypes_
#define _systypes_

#include "H3DNetworkingUtils/Config.h"

/*-- Platform Identification Defines ---------------------------------*/

#if defined(_WIN32) || defined(WIN32)
#   define PLATFORM_WIN32
#   define PLATFORM WIN32

#elif defined(__sgi)
#   define PLATFORM_SGI_IRIX
#   define PLATFORM SGI_IRIX
#   define PLATFORM_UNIX

#elif defined (__osf__) && defined(__alpha) 
#   define PLATFORM_DIGITAL_UNIX
#   define PLATFORM DIGITAL_UNIX
#   define PLATFORM_UNIX

#elif defined(__linux) && defined(__i386)
#   define PLATFORM_X86_LINUX
#   define PLATFORM X86_LINUX
#   define PLATFORM_UNIX

#else
#   define PLATFORM_UNKNOWN
#   define PLATFORM UNKNOWN
#   define PLATFORM_UNIX

#endif

/*-- Platform independent types ----------------------------------------
/
/   TYPES
/	int8, int16, int32, int64 -- signed integers
/	uint8, uint16, uint32, uint64 -- unsigned integers
/	float32 -- guaranteed single precision
/   MACROS
/	htonXX, ntohXX -- host-to-network and network-to-host
/   PLATFORMS
/   1.	Win32 -- 64 bit support is nominal
/   2.	SGI/MIPS -- 64 bit support guaranteed on 64 bit processors
/   3.  OSF/ALPHA -- 64 bit support guaranteed
/   4.  Linux/x86 -- 64 bit support maybe?
*/

#if defined(PLATFORM_WIN32)
#   include <winsock.h>
    typedef __int8	    int8;
    typedef __int16	    int16;
    typedef __int32	    int32;
    typedef __int64	    int64;
    typedef unsigned char   uint8;
    typedef unsigned short  uint16;
    typedef unsigned int    uint32;
    typedef unsigned __int64 uint64;
    typedef float	    float32;


#elif defined(PLATFORM_SGI_IRIX)
#   include <sys/types.h>
    typedef int8_t	    int8;
    typedef int16_t	    int16;
    typedef int32_t	    int32;
    typedef int64_t	    int64;
    typedef uint8_t	    uint8;
    typedef uint16_t	    uint16;
    typedef uint32_t	    uint32;
    typedef uint64_t	    uint64;
    typedef float	    float32;


#elif defined(PLATFORM_X86_LINUX)
#   include <sys/types.h>
    typedef __int8_t	    int8;
    typedef __int16_t	    int16;
    typedef __int32_t	    int32;
    typedef __int64_t	    int64;
    typedef __uint8_t	    uint8;
    typedef __uint16_t	    uint16;
    typedef __uint32_t	    uint32;
    typedef __uint64_t	    uint64;
    typedef float	    float32;


#elif defined (PLATFORM_DIGITAL_UNIX) 
#   include <netinet/in.h>
    typedef char	    int8;
    typedef short	    int16;
    typedef int		    int32;
    typedef long	    int64;
    typedef unsigned char   uint8;
    typedef unsigned short  uint16;
    typedef unsigned int    uint32;
    typedef unsigned long   uint64;

#endif

typedef uint8 byte;

#define  hton16 htons
#define  hton32 htonl
#define  hton64 <<ERROR>>
#define  ntoh16 ntohs
#define  ntoh32 ntohl
#define  ntoh64 <<ERROR>>

#if defined(PLATFORM_WIN32) || defined(PLATFORM_X86_LINUX)
    extern float32 H3D_NETWORKING_UTILS_DLL_SPEC ntohf (float32 f);
    extern float32 H3D_NETWORKING_UTILS_DLL_SPEC htonf (float32 f);
#elif defined(PLATFORM_SGI_IRIX)
#   define ntohf(f) (f)
#   define htonf(f) (f)
#endif

#endif

