/*****************************
File:      lockwrap.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
   Samuel Taylor, (sam.taylor@anu.edu.au)
   Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

// The lockwrap class provides a OO wrapper around Mutex locks.

#ifndef _lockwrap_
#define _lockwrap_

#include "H3DNetworkingUtils/Config.h"

class H3D_NETWORKING_UTILS_DLL_SPEC  Mutex {
  protected:
    void * sysMutex;

  public:
    Mutex ();
    virtual ~Mutex ();
     
    void * sysRef () { return sysMutex; }
    
    virtual void lock ();
    virtual void unlock ();
    
    //virtual bool  tryLock ();
    virtual int  tryLock ();
    // Returns true if successful
};

class H3D_NETWORKING_UTILS_DLL_SPEC  Semaphore {
  protected:
    void * sysSemaphore;

  public:
    Semaphore (int count);
    virtual ~Semaphore ();

    void * sysRef () { return sysSemaphore; }

    virtual void signal ();
    virtual void wait ();
    //virtual bool  tryWait ();
    virtual int  tryWait ();
};

#endif
