/*****************************
File:      inetaddr.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is ANU.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Samuel Taylor, (sam.taylor@anu.edu.au)
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// The inetaddr class contains an Inet address

#ifndef _inetaddr_
#define _inetaddr_

#ifdef _WIN32
#include <winsock.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#endif
#include "H3DNetworkingUtils/Config.h"

class H3D_NETWORKING_UTILS_DLL_SPEC  InetAddr {
  protected:
    struct sockaddr_in address;
    char   addressStr[24]; // Dotted IP plus : plus port

  public:
    InetAddr ();
    virtual ~InetAddr ();

    virtual int family ();
    virtual int port ();
    virtual void setPort (int newPort);

    // Pointer to sin_addr field of address, for passing
    // to socket functions and inet_ntop/pton functions.
    virtual void * addr ();
    virtual int    addrSize ();

    // Construct address from string representation.
    // Addr: Host/Port or Host:Port
    // Host: name or dotted IP
    // Port: number or registered service name
    virtual void scan (char * addr);
    
    virtual void scanHost (char * host);
    virtual void scanPort (char * port);
        
    // Copy
    virtual InetAddr * clone ();
    
    // Presentation format for output
    virtual char * text ();

    // Attributes
    virtual int isUnicast ();
    virtual int isMulticast ();
    virtual int isLocal ();

    // testing
    virtual int eqHost (InetAddr * other);
    virtual int eqPort (InetAddr * other);

    // Handy call. Returns unqualified host name
    static char * HostName ();
};

#endif
