/*****************************
File:      fail.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Samuel Taylor, (sam.taylor@anu.edu.au)
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// The fail class provides error messages 

#ifndef _fail_
#define _fail_

#include "H3DNetworkingUtils/Config.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Distributed under a BSD type license. See the netwrap COPYRIGHT file */

extern void H3D_NETWORKING_UTILS_DLL_SPEC  Fail (char * message);

extern void H3D_NETWORKING_UTILS_DLL_SPEC  FailNull (void * ptr, char * message);

/* Unix standard negative error codes */
extern void H3D_NETWORKING_UTILS_DLL_SPEC  FailErr (int code, char * message);

/* Portable way to set errno */
extern void H3D_NETWORKING_UTILS_DLL_SPEC  SetErrNo (int code);

/* For systems like X and Posix threads that return
   zero on success and positive numbers on error */
extern void H3D_NETWORKING_UTILS_DLL_SPEC  FailStatus (int code, char * message);

#ifdef __cplusplus
}
#endif

#endif
