/*****************************
File:      TimePacket.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

// The TimePacket class provides a packet of data representing a time value that can be sent across a network.

#ifndef TimePacket_H
#define TimePacket_H

#include <iostream>

#include <H3DUtil/H3DBasicTypes.h>

class H3D_NETWORKING_UTILS_DLL_SPEC TimePacket {
public:
  bool state;
  H3D::H3DTime send_time;
  H3D::H3DTime remote_time;
  H3D::H3DTime receive_time;
  bool operator==(TimePacket const & other) const {
    return ((send_time == other.send_time) &&
            (remote_time == other.remote_time) &&
            (receive_time == other.receive_time));
  }
  TimePacket() : state (false), send_time(0), remote_time(0), receive_time(0) {}
  virtual ~TimePacket() {std::cerr << "~TimePacket" << std::endl;}
  TimePacket & operator=(TimePacket const & other) {
    if (this == &other)
      return *this;
    send_time = other.send_time;
    remote_time = other.remote_time; 
    receive_time = other.receive_time;
    state = other.state;
    return *this;
  }
  TimePacket(TimePacket const & other) :
    send_time (other.send_time),
    remote_time (other.remote_time), 
    receive_time (other.receive_time),
    state (other.state) {}
};

inline std::ostream& operator<<(std::ostream& out, const TimePacket& T) {
  out << T.send_time << '.. ' << T.remote_time << '.. ' << T.receive_time << std::endl;
  return out;
}

//inline bool TimePacket::operator==(const & TimePacket other) const {
//  return ((send_time == other.send_time) &&
//          (remote_time == other.remote_time) &&
//          (receive_time == other.receive_time));
//}

#endif
