/*****************************
File:      RemoteConnection.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file RemoteConnection.h
/// \brief Header file for RemoteConnection, a base class for networking clients and servers.

#ifndef ThreadSafeBool_H
#define ThreadSafeBool_H


#include "H3DNetworkingUtils/Config.h"
#include "H3DNetworkingUtils/lockwrap.h"

class H3D_NETWORKING_UTILS_DLL_SPEC ThreadSafeBool {
   public:
      ThreadSafeBool(bool v = false) : value(v) {}
      void set(const bool & v) {
         lock.lock();
         value = v;
         lock.unlock();
      }
      bool get() {
         bool tmp;
         lock.lock();
         tmp = value;
         lock.unlock();
         return tmp;
      }
      bool operator=(const bool & v) {
         lock.lock();
         value = v;
         lock.unlock();
         return v;
      }
      bool operator==(const bool & v) const {
         bool ret = false;
         lock.lock();
         ret = (value == v);
         lock.unlock();
         return ret;
      }
      bool operator!=(const bool & v) const {
         bool ret = false;
         lock.lock();
         ret = (value != v);
         lock.unlock();
         return ret;
      }
   private:
      mutable Mutex lock;
      bool value;
};

#endif