/*****************************
File:      StickySlotDynamic.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file StickySlotDynamic.h
/// \brief Header file for StickySlotDynamic, a Dynamic that has 'stickyness'.

#ifndef StickySlotDynamic_H
#define StickySlotDynamic_H


#include "H3DNetworkingUtils/Config.h"
#include "H3DNetworkingUtils/StickyDynamic.h"

namespace H3DNetworkingUtils {

/// \class StickySlotDynamic
/// The StickySlotDynamic class is a StickyDynamic that moves only on the X direction, and has a start end end point
///
/// <b>Examples:</b>
///   - <a href="../../examples/StickySlotDynamicTest.x3d">StickySlotDynamicTest.x3d</a>

class H3D_NETWORKING_UTILS_DLL_SPEC StickySlotDynamic : public H3DNetworkingUtils::StickyDynamic {
public:
   /// Constructor
   StickySlotDynamic(H3D::Inst<H3D::SFBool> locked = 0,
                     H3D::Inst<H3D::SFFloat> startForce = 0,
                     H3D::Inst<H3D::SFFloat> slideForce = 0,
                     H3D::Inst<H3D::SFFloat> friction = 0,
					      H3D::Inst<H3D::SFTime> stopDelay = 0,
					      H3D::Inst<H3D::SFFloat> start = 0,
					      H3D::Inst<H3D::SFFloat> end = 0);

   // The X3D interface
   static H3D::H3DNodeDatabase database;

   // Public fields

   /// The left hand slot end
   /// access type: inputOutput \n
   /// basic type: SFFloat \n
   /// default value: 0
   auto_ptr<H3D::SFFloat> start;

   /// The right hand slot end
   /// access type: inputOutput \n
   /// basic type: SFFloat \n
   /// default value: 1.0
   auto_ptr<H3D::SFFloat> end;

protected:

   virtual void traverseSG(H3D::TraverseInfo & ti);

};

}

#endif

