/*****************************
File:      SlaveDynamic.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file SlaveDynamic.h
/// \brief Header file for SlaveDynamic, a Dynamic that can mimic the behaviour of another Dynamic on a remote system.
/// \brief Note that this node is redundant and is included for backwards compatibility.
/// \brief It is just a GrabableDynamic with slaveMode set to TRUE.

#ifndef SlaveDynamic_H
#define SlaveDynamic_H

#include "H3DNetworkingUtils/Config.h"
#include "H3DNetworkingUtils/GrabableDynamic.h"

namespace H3DNetworkingUtils {

/// \class SlaveDynamic
/// \brief The SlaveDynamic superceded and is included for backwards compatibility -  It is simply a GrabableDynamic with slaveMode set to TRUE.

class H3D_NETWORKING_UTILS_DLL_SPEC SlaveDynamic : public GrabableDynamic {
public:

  struct DiffVec3f;
  
  /// Constructor
  SlaveDynamic();

   /// X3D interface
  static const H3D::H3DNodeDatabase H3DNodeDatabase;
  
};

typedef H3D::TypedSFNode< SlaveDynamic > SFSlaveDynamic;
}

#endif
