/*****************************
File:      MouseHapticDevice.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file SFTimePacket.h
/// \brief Header file for SFTimePacket, template specializations in order to get nicer type printouts.

#ifndef SFTimePacket_H
#define SFTimePacket_H

#include "H3DNetworkingUtils/Config.h"
#include "H3DNetworkingUtils/TimePacket.h"
#include <H3D/SField.h>
#include <H3D/X3DTypes.h>

namespace H3D {
  template<>
  inline string H3D::SField< TimePacket >::classTypeName() { return "SFTimePacket"; }
}

namespace H3DNetworkingUtils {

  /// \class SFTimePacket
  /// template specializations in order to get nicer type printouts.
  class H3D_NETWORKING_UTILS_DLL_SPEC SFTimePacket: public H3D::SField< TimePacket > {
  public:
    /// Constructor
    SFTimePacket() {}

    /// Constructor
    SFTimePacket( const TimePacket &_value ): H3D::SField< TimePacket >( _value ){}
    
	 virtual H3D::X3DTypes::X3DType getX3DType() { return H3D::X3DTypes::SFTIME; }
  };
}

#endif

