#ifndef RemoteVecToAttractor_H
#define RemoteVecToAttractor_H

// NOTE: I don't think this class is needed. If you route from a normal RemoteSFvec3f to the realtimePoint
// of a realtimeAttractor, it has nothing to do with the graphics loop, so it should be affected.
// We'll leave it in the library for now.

// A derivation of RemoteSFVec3f that directly sets a RealTimeAttractor with
// its value instead of allowing the value to be routed to it. This is because the
// value needs to be set in the haptics loop (since it is a realtime Attractor) and
// the normal routing mechanism can get in a tangle when used in the haptic loop.
// Fields:
// <field "INPUT_OUTPUT"  "attractor" "SFRealtimeAttractor" "">
//
#include "H3DNetworkingUtils/RemoteSFVec3f.h"
#include "H3DNetworkingUtils/RealtimeAttractor.h"
#include "H3DNetworkingUtils/Config.h"

namespace H3DNetworkingUtils {
   
class H3D_NETWORKING_UTILS_DLL_SPEC RemoteVecToAttractor : public RemoteSFVec3f {
public:
  struct SFRealtimeAttractor;
  
  RemoteVecToAttractor(H3D::Inst<SFRealtimeAttractor>  _attractor = 0);

  static H3D::H3DNodeDatabase database;

  virtual void initialize();

  struct SFRealtimeAttractor : public H3D::TypedSFNode<RealtimeAttractor> {
    virtual void onAdd(H3D::Node * nodeP) {
       RemoteVecToAttractor * vec_attrP = static_cast<RemoteVecToAttractor *>(getOwner());
       vec_attrP->attrP = static_cast<RealtimeAttractor*>(nodeP);
       TypedSFNode<RealtimeAttractor>::onAdd(nodeP);
     }
     virtual void onRemove(H3D::Node * nodeP) {
       RemoteVecToAttractor * vec_attrP = static_cast<RemoteVecToAttractor *>(getOwner());
       vec_attrP->attrP = 0;
       TypedSFNode<RealtimeAttractor>::onRemove(nodeP);
     }
  };

  // Public fields
  auto_ptr<SFRealtimeAttractor>  attractor;

protected:
  virtual void readValue();
  // Read the field's value into the attractor's realtimePoint field.

private:
  RealtimeAttractor * attrP; // Note we don't use an auto_ptr or AutoRef here. This is dangerous,
                             // but we do it anyway for the sake of efficiency because it is 
                             // called in the haptics loop.

};

}

#endif
