/*****************************
File:      RemoteTimePacket.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
// The RemoteTimePacket class provides a remote TimePacket field.  It inherits most of its functionality from its
// parent class.
// This class adds a VRML database and the details of how to read and write
// the field data.

// <INPUT_ONLY  "toBeSent" "SFTime" "" >
// <OUTPUT_ONLY "received"   "SFTime" "" >

#ifndef RemoteTimePacket_H
#define RemoteTimePacket_H


#include "H3DNetworkingUtils/RemoteSF.h"
#include "H3DNetworkingUtils/TimePacket.h"
#include "H3DNetworkingUtils/SFTimePacket.h"

namespace H3DNetworkingUtils {

class H3D_NETWORKING_UTILS_DLL_SPEC RemoteTimePacket : public RemoteSF< SFTimePacket> {
public:
  
  RemoteTimePacket();
  
  static H3D::H3DNodeDatabase database;

protected:
  virtual void readValue();
  // Read the parts of a fields value into the received field.

  virtual void writeValue( const TimePacket & val );
  // Send the correct parts of the value.

};

}

#endif
