/*****************************
File:     RemoteTCPClient.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file RemoteTCPClient.h
/// \brief Header file for RemoteTCPClient, a client communications link that uses TCP/IP network protocol.

#ifndef RemoteTCPClient_H
#define RemoteTCPClient_H



#include "H3DNetworkingUtils/RemoteClient.h"
#include "H3DNetworkingUtils/RemoteField.h"
//#include "Macro.h"
#include "H3DNetworkingUtils/sockwrap.h"

namespace H3DNetworkingUtils {
   
/// \class RemoteTCPClient
/// The RemoteTCPClient class starts a Remote client using a TCP socket.
/// It tries to connect to a RemoteServer node on the given host using
/// the given port, then continues with the base class's behaviour.
/// When open is changed from false to true, the connection is attempted.
/// When it is changed from true to false, the connection is closed.
/// At present, only one remote connection is handled.  \n
/// <b>Examples:</b>
///   - <a href="../../examples/RemoteSFTestServer.x3d">RemoteMFTestServer.x3d</a>
///   - <a href="../../examples/RemoteSFTestClient.x3d">RemoteMFTestClient.x3d</a>

class H3D_NETWORKING_UTILS_DLL_SPEC RemoteTCPClient : public RemoteClient {
public:

  /// Constructor
  RemoteTCPClient();
  
  /// Destructor
  virtual ~RemoteTCPClient();

  /// X3D interface
  static H3D::H3DNodeDatabase database;

protected:

  static void clientReceivingLoopTH(void * client_data) {
    static_cast<RemoteTCPClient*>(client_data)->clientReceiveLoop();
  }

  /// Called in the recieving thread.
  virtual void clientReceiveLoop();

  /// Start the receiving thread.
  virtual void startReceiving();

  /// Restarts the client reading and writing to a new socket.
  virtual void restartClient();

};

}

#endif
