/*****************************
File:      RemoteSFVec3f.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file RemoteSFVec3f.h
/// \brief Header file for RemoteSFVec3f, sends and receives a Vec3f value.

#ifndef RemoteSFVec3f_H
#define RemoteSFVec3f_H

#include "H3DNetworkingUtils/RemoteSF.h"
#include <H3D/SFVec3f.h>

namespace H3DNetworkingUtils {
   
/// \class RemoteSFVec3f
/// The RemoteSFVec3f class provides a remote single Vec3f field.  It inherits most of its funtionality from its parent
/// class.
/// This class adds a X3D database and the details of how to read and write
/// the field data. \n
/// Use the 'toBeSent' and 'received' fields of the base class.  \n
/// <b>Examples:</b>
///   - <a href="../../examples/RemoteSFTestServer.x3d">RemoteMFTestServer.x3d</a>
///   - <a href="../../examples/RemoteSFTestClient.x3d">RemoteMFTestClient.x3d</a>

class H3D_NETWORKING_UTILS_DLL_SPEC RemoteSFVec3f : public RemoteSF<H3D::SFVec3f> {

public:
  /// Constructor
   RemoteSFVec3f();

  /// X3D interface
   static H3D::H3DNodeDatabase database;

   /// This is a debug function only   \n
   /// To be used to simulate receiving a remote connection change of value, when there is no remote connection.
   void setValue(H3D::Vec3f const & val);

protected:
  /// Read the parts of a fields value into the received field.
  virtual void readValue();

  /// Write the correct parts of the value.
  virtual void writeValue(H3D::Vec3f const & pos);
};

}

#endif
