/*****************************
File:      RemoteNormalVector.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file RemoteNormalVector.h
/// \brief Header file for RemoteNormalVector, provides network access to the vector field of a Normal node.

#ifndef RemoteNormalVector_H
#define RemoteNormalVector_H

#include "H3DNetworkingUtils/Config.h"
#include "H3DNetworkingUtils/RemoteNodeField.h"
#include <H3D/Normal.h>         
#include <H3D/MFVec3f.h>         

template struct __declspec(dllimport) H3D::AutoUpdate <H3D::Field>;

namespace H3DNetworkingUtils {

/// \class RemoteNormalVector
/// The RemoteNormalVector class provides network access to the vector field of a Normal node.
/// It alows individual normals to be modified over the network without sending all the normals in the array \n\n
/// Example of use: \n
/// @code
///   <RemoteTCPClient DEF="client" remoteHost="localhost" remotePort="50000" open="TRUE">       
///      <RemoteNormalVector DEF="remote_norm_vec" fieldId="0">                                 
///         <Normal USE="my_normss" containerField="theNode"/>                               
///      </RemoteNormalVector>                                                                     
///   </RemoteTCPClient> 
/// @endcode
/// Note that, unlike other RemoteFields, no separate routing of the points needs to occur, as the USE statement handles this.
/// However, you must route to one of sendAll, indiciesToBeSent or indexToBeSent to trigger values to be sent at all.  \n
/// <b>Examples:</b>
///   - <a href="../../examples/RemoteNormalVectorTestServer.x3d">RemoteNormalVectorTestServer.x3d</a>
///   - <a href="../../examples/RemoteNormalVectorTestClient.x3d">RemoteNormalVectorTestClient.x3d</a>

class H3D_NETWORKING_UTILS_DLL_SPEC RemoteNormalVector : 
	     public RemoteNodeField<H3D::Normal, H3D::MFVec3f, &H3D::Normal::vector>  {
public:
   RemoteNormalVector();

   static H3D::H3DNodeDatabase database;

protected:
   /// Write value to socket
   virtual void writeValue (H3D::Vec3f const & val);

   /// Read value from socket
   virtual H3D::Vec3f readVal();

};

}

#endif
