/*****************************
File:      RemoteMFInt32.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file RemoteMFInt32.h
/// \brief Header file for RemoteMFBool, sends and receives boolean values.

#ifndef RemoteMFInt32_H
#define RemoteMFInt32_H

#include "H3DNetworkingUtils/RemoteMF.h"
#include <H3DUtil/H3DBasicTypes.h>
#include <H3D/MFInt32.h>

namespace H3DNetworkingUtils {
   
/// \class RemoteMFInt32
/// The RemoteMFInt32 class provides a remote multiple int field.  It inherits most of its funtionality from its parent
/// class.
/// This class adds a X3D database and the details of how to read and write
/// the field data. \n
/// Use the toBeSent and received fields of the base class.  \n
/// <b>Examples:</b>
///   - <a href="../../examples/RemoteMFTestServer.x3d">RemoteMFTestServer.x3d</a>
///   - <a href="../../examples/RemoteMFTestClient.x3d">RemoteMFTestClient.x3d</a>

class H3D_NETWORKING_UTILS_DLL_SPEC RemoteMFInt32 : public RemoteMF< H3D::MFInt32> {
public:

  RemoteMFInt32();

  static H3D::H3DNodeDatabase database;

protected:

  virtual void readValue();
  // Read the parts of a fields value into the received field.

  virtual void writeValue( vector<int> const &val);
  // Write the correct parts of the value.
};

}

#endif

