/*****************************
File:      RemoteCoordPoint.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file RemoteCoordPoint.h
/// \brief Header file for RemoteCoordPoint, provides network access to the point field of a Coordinate node.

#ifndef RemoteCoordPoint_H
#define RemoteCoordPoint_H

#include "H3DNetworkingUtils/Config.h"
#include "H3DNetworkingUtils/RemoteNodeField.h"
#include <H3D/Coordinate.h>         
#include <H3D/MFVec3f.h>         

template struct __declspec(dllimport) H3D::AutoUpdate <H3D::Field>;

namespace H3DNetworkingUtils {

/// \class RemoteCoordPoint
/// The RemoteCoordPoint class provides network access to the point field of a Coordinate node.
/// It alows individual points to be modified over the network without sending all the points in the array \n\n
/// Example of use (X3D): \n
/// @code
///   <RemoteTCPClient DEF="client"
///      remoteHost="localhost"
///      remotePort="50000"
///      open="TRUE">
///      <RemoteCoordPoint DEF="remote_coord_point" fieldId="0">
///         <Coordinate USE="slave1_coords" containerField="theNode"/>
///      </RemoteCoordPoint>
///   </RemoteTCPClient>
/// @endcode
/// Note that, unlike other RemoteFields, no separate routing of the points needs to occur, as the USE statement handles this.
/// However, you must route to one of sendAll, indiciesToBeSent or indexToBeSent to trigger values to be sent at all.  \n
/// <b>Examples:</b>
///   - <a href="../../examples/RemoteCoordPointTestServer.x3d">RemoteCoordPointTestServer.x3d</a>
///   - <a href="../../examples/RemoteCoordPointTestClient.x3d">RemoteCoordPointTestClient.x3d</a>

class H3D_NETWORKING_UTILS_DLL_SPEC RemoteCoordPoint : public RemoteNodeField<H3D::Coordinate, H3D::MFVec3f, &H3D::Coordinate::point>  {
public:
   /// Constructor
   RemoteCoordPoint();

   /// X3D interface
   static H3D::H3DNodeDatabase database;

protected:
   /// Write value to socket
   virtual void writeValue (H3D::Vec3f const & val);

   /// Read value from socket
   virtual H3D::Vec3f readVal();

};

}

#endif
