/*****************************
File:      PacketSequenceChecker.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file PacketSequenceChecker.h
/// \brief Header file for PacketSequenceChecker, contains packet sequence checking logic.


#ifndef PacketSequenceChecker_H
#define PacketSequenceChecker_H

#ifdef MAGMA_IRIX
#define H3D Magma
#endif

#include "H3DNetworkingUtils/Config.h"
#include <iostream>

namespace H3DNetworkingUtils {
   
/// \class PacketSequenceChecker
/// The PacketSequenceChecker class provides checking on sequence numbers sent in network packet headers.
/// (see Packet.h)

class H3D_NETWORKING_UTILS_DLL_SPEC PacketSequenceChecker {
public:
  typedef unsigned short u_int16;
  typedef short int16;
  typedef unsigned int   u_int32;

  /// Constructor
  PacketSequenceChecker();

  /// Check seq to see if it in sequence.
  /// Returns true if it is in sequence.
  virtual bool inSequence(u_int16 seq);

protected:

  private:
  static const int MIN_SEQUENTIAL;
  static const int MAX_ALLOWABLE_DIFF;
  static const int WRAP_CHECK;


  u_int16 prev_seq_num;  // highest seq. number seen */
  u_int16 bad_seq;       // last 'bad' seq number + 1 */
  u_int16 probation;     // sequ. packets till source is valid */
};

}

#endif
