/*****************************
File:      Hinge.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file Hinge.h
/// \brief Header file for Hinge, turns a Dynamic into a Hinge about the x axis

#ifndef Hinge_H
#define Hinge_H

#include "H3DNetworkingUtils/Config.h"
#include "H3DNetworkingUtils/Dynamic.h"
#include "H3D/MFVec3f.h"
#include "H3D/SFVec3f.h"
#include "H3D/SFMatrix4f.h"
#include "H3D/SFInt32.h"
#include "H3D/MFInt32.h"

namespace H3DNetworkingUtils {

/// \class Hinge
/// The Hinge class is a Dynamic that is limited in its rotations such that it behaves like a hinge around the (1, 0, 0) axis
/// It can rotate from an angle of 0, to a maxAngle 
/// If maxAngle is 0, it can rotate indefinately
/// The axis of the parent Dynamic is fixed on (1, 0, 0)

class H3D_NETWORKING_UTILS_DLL_SPEC Hinge : public H3DNetworkingUtils::Dynamic {

public:

   /// Constructor
   Hinge( H3D::Inst< AddChildren              > _addChildren        = 0,
            H3D::Inst< RemoveChildren           > _removeChildren     = 0,
            H3D::Inst< MFChild                  > _children           = 0,
            H3D::Inst< H3D::SFNode              > _metadata           = 0,
            H3D::Inst< SFBound                  > _bound              = 0,
            H3D::Inst< H3D::SFVec3f             > _bboxCenter         = 0,
            H3D::Inst< H3D::SFVec3f             > _bboxSize           = 0,
            H3D::Inst< SFTransformedBound       > _transformedBound   = 0,
            H3D::Inst< SFMatrix4f               > _matrix             = 0,
            H3D::Inst< SFMatrix4f               > _accumulatedForward = 0,
            H3D::Inst< SFMatrix4f               > _accumulatedInverse = 0,
            H3D::Inst< H3D::SFVec3f             > _position           = 0,
            H3D::Inst< H3D::SFRotation          > _orientation        = 0,
            H3D::Inst< SFVelocity               > _velocity           = 0,
            H3D::Inst< H3D::SFVec3f             > _momentum           = 0,

            H3D::Inst< H3D::SFVec3f             > _force              = 0,
            H3D::Inst< SFAngularVelocity        > _angularVelocity    = 0,
            H3D::Inst< H3D::SFVec3f             > _angularMomentum    = 0, 
            H3D::Inst< SFSpin                   > _spin               = 0,
            H3D::Inst< H3D::SFVec3f             > _torque             = 0,
            H3D::Inst< H3D::SFFloat             > _mass               = 0,
            H3D::Inst< H3D::SFMatrix3f          > _inertiaTensor      = 0,
            H3D::Inst< SFMotion                 > _motion             = 0,
            
            H3D::Inst<H3D::MFVec3f              > _contactForces      = 0,
            H3D::Inst<H3D::MFVec3f              > _contactTorques     = 0,
            H3D::Inst<SumMFVec3f                > _totalContactForce  = 0,
            H3D::Inst<SumMFVec3f                > _totalContactTorque = 0,
            H3D::Inst<SumForces                 > _externalForces     = 0,
            H3D::Inst<SumTorques                > _externalTorques    = 0,
            H3D::Inst<H3D::SFVec3f              > _freedom            = 0,
            H3D::Inst<H3D::SFVec3f              > _angularFreedom     = 0,
            H3D::Inst<H3D::SFFloat              > _linearDamping      = 0,
            H3D::Inst<H3D::SFFloat              > _rotationalDamping  = 0,
            H3D::Inst<H3D::SFFloat              > _linearSpringStiffness = 0,
            H3D::Inst<H3D::SFFloat              > _angularSpringStiffness = 0,
            H3D::Inst<H3D::SFVec3f              > _globalPosition     = 0,
            H3D::Inst<H3D::SFFloat              > _maxAngle = 0);
   
   // The X3D interface
   static H3D::H3DNodeDatabase database;

   virtual void initialize();
   
   virtual void traverseSG(H3D::TraverseInfo & ti);


   /// This node can optionally can have limits on its orientation angle \n
   /// access type: inputOutput \n
   /// basic type: SFFloat \n
   /// default value:0 (effectively no limit)
   auto_ptr<H3D::SFFloat>     maxAngle;

private:
   H3D::Rotation                    prev_rot;
   bool                             axis_flipped;
};

}
#endif