/*****************************
File:      FilteredSVec.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file FilteredSFVec3f.h
/// \brief Header file for FilteredSFVec3f, filters a Vec3f stream depending on past history.


#ifndef FilteredSFVec3f_H
#define FilteredSFVec3f_H

#include <H3DUtil/H3DMath.h>
#include "H3DNetworkingUtils/VecFilter.h"
#include <H3D/SFVec3f.h>
#include <H3D/SFInt32.h>

namespace H3DNetworkingUtils {

/// \class FilteredSFVec3f
/// The FilteredSFVec3f class is an SFVec3f that modifies its value to
/// one that is a filtered average of past values.
/// This is based on its recent past history of change. i.e. it is
/// based on its values in the past, filtered through a sin(t)/t filter.
/// The first input is the current value being passed to the field.
/// The second input is the number of past values to include in the averaging -
/// this is not expected to vary. If you do change it, there will be a
/// discontinuity in the output as the new sample size is filled.
/// The output is the filtered value.
/// The field stores past values for averaging.  If there are not enough past
/// values, the number available are used.

   class H3D_NETWORKING_UTILS_DLL_SPEC FilteredSFVec3f : public  H3D::TypedField < H3D::SFVec3f,
                                 H3D::Types<H3D::SFVec3f, H3D::SFInt32> > {
public:
  /// Constructor
  FilteredSFVec3f() : filterP (0) {}

  /// update: performs the filtering using the usual field updating mechanism.
  virtual void update();

private:
  VecFilter * filterP;
};

}

#endif
