/*****************************
File:      EndianCheck.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file EndianCheck.h
/// \brief Header file for EndianCheck, reports on big endian or little endian systems.


#ifndef EndianCheck_H
#define EndianCheck_H

#include "H3DNetworkingUtils/Config.h"

namespace H3DNetworkingUtils {
   
/// \class EndianCheck
/// The EndianCheck class provides a way to check if the host machine is big or little endian.
/// Note that the functions isBigEndian() and isLittleEndian() just return a
/// boolean value that is figured out at program startup, so they should be
/// efficient.

class H3D_NETWORKING_UTILS_DLL_SPEC EndianCheck {
public:
  /// Constructor
  EndianCheck()  {
    union {
      short s;
      char c[sizeof(short)];
    } un;

    un.s = 0x0102;
    if (sizeof(short) == 2) {
      if (un.c[0] == 2 && un.c[1] == 1) {
        little_endian = true;
      }
      else if (un.c[0] == 1 && un.c[1] == 2) {
        little_endian = false;
      }
    }
  }
  
  /// isBigEndian.
  static bool isBigEndian() {return !instance.little_endian;}

  /// isLittleEndian.
  static bool isLittleEndian() {return instance.little_endian;}

  static EndianCheck instance;
private:
  static bool little_endian;
};

}

#endif
