/*****************************
File:      CollisionSphereHierarchy.h
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/// \file CollisionSphereHierarchy.h
/// \brief Header file for CollisionSphereHierarchy, a hierarchy of collision spheres.


#ifndef CollisionSphereHierarchy_H
#define CollisionSphereHierarchy_H

#include "H3DNetworkingUtils/Config.h"
#include "H3DNetworkingUtils/CollisionSphere.h"

namespace H3DNetworkingUtils {

/// \class CollisionSphereHierarchy
/// The CollisionSphereHierarchy class is a CollisionSphere that can also have a set of other 
/// CollidableSpheres arranged in its 'collidables" field.  \n
/// <b>Examples:</b>
///   - <a href="../../examples/CollisionGroupTest.x3d">CollisionGroupTest.x3d</a>

class H3D_NETWORKING_UTILS_DLL_SPEC CollisionSphereHierarchy : public CollisionSphere {
public:
  
   class H3D_NETWORKING_UTILS_DLL_SPEC MFCollidableGeometry : public H3D::TypedMFNode< CollisionGeometry > {
   public:
      virtual void onAdd( Node *n);
      virtual void onRemove( Node *n);
   };

  /// Constructor
   CollisionSphereHierarchy(     
    H3D::Inst< MFCollidableGeometry > _collidables = 0,
    H3D::Inst< CollisionSphere::Radius > _radius = 0);

  /// Initialize
  virtual void initialize();
  
  /// The children spheres \n
  /// access type: inputOutput \n
  /// basic type: MFNode \n
  /// default value: 
  auto_ptr< MFCollidableGeometry > collidables;

  static H3D::H3DNodeDatabase database;
  
  /// Set the Dynamic that contains this CollisionGeometry /n
  /// This goes through the whole hierarchy, calling setDyn()
  virtual void setDyn( CollidableDynamic *ptr );
  
};

}

#endif 
