/*****************************
File:      BufferedMField.cpp
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

#include "H3DNetworkingUtils/BufferedMField.h"
//#include "RemoteTimePacket.h"

using namespace H3D;
using namespace H3D::X3DTypes;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
template <class M>
BufferedMField<M>::BufferedMField() :
buffer_strategy (NONE),
x3d_type (UNKNOWN_X3D_TYPE) {
}

// ----------------------------------------------------------------------------
template <class M>
void BufferedMField<M>::setValue(const vector<typename M::value_type> &  val, int id ) {
   // All calls to setValue() can happen in any thread, e.g. a network reading thread
   change_lock.lock();
   temp_vals.push_back(val);
   change_lock.unlock();

   M::setValue(val, id);
}

// ----------------------------------------------------------------------------
template <class M>
void BufferedMField<M>::update() {
   // Update shouldn't occur as this is an output field and should have no input routes, therefore no event.
   // But we'll put in the code anyway.
   M * val = static_cast<M *>(event.ptr);
   // buffering
   change_lock.lock();
   temp_vals.push_back(val->getValue());    
   change_lock.unlock();
}

// ----------------------------------------------------------------------------
template <class M>
void BufferedMField<M>::checkForChange(int id) {
  // All calls to checkForChange() can happen in either the graphics or haptics thread

   if (!temp_vals.empty()) {
    if (buffer_strategy == NONE) {
      // Get last value and clear queue
      change_lock.lock();
      vector<typename M::value_type> val = temp_vals.back();
      temp_vals.clear();
      change_lock.unlock();
      M::setValue(val, id);
    } else if (buffer_strategy == SET_ONE_PER_CYCLE) {
      // get first value and pop from queue
      change_lock.lock();
      vector<typename M::value_type> val = temp_vals.front();
      temp_vals.pop_front();
      change_lock.unlock();
      M::setValue(val,id);
   } else { // SET_ALL
      // get each value in sequence
      change_lock.lock();
      std::deque<vector<typename M::value_type> > vals = temp_vals;
      temp_vals.clear();  
      change_lock.unlock();
      for (deque<vector<typename M::value_type> >::iterator i = vals.begin(); i != vals.end(); i++) {
         M::setValue(*i, id);
      }
    }
  }
}

