#
#File:      SFStringToMFString.py*
#Language:   C++ (header)
#Project:    H3DNetworkingUtils
#The contents of this file are subject to the Mozilla Public License
#Version 1.1 (the "License"); you may not use this file except in
#compliance with the License. You may obtain a copy of the License at
#http://www.mozilla.org/MPL/
 #
#Software distributed under the License is distributed on an "AS IS"
#basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
#License for the specific language governing rights and limitations
#under the License.
 #
#The Original Code is H3DNetworkingUtils v1.0.
#
#The Initial Developer of the Original Code is CSIRO.
#Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
#Contributor(s):
#    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
#

from H3DInterface import *

# This returns the first field (an MFString) modified with the contents of the 
# one of the other fields (SFString) - whichever has changed.
# It will modify the string of the MFString matching the number of the field that changes
# Within this string, it will replace the characters starting at self.char_index
# It then returns the resulting string

class SFStringToMFString(TypedField(MFString, MFString, SFString)):
	def __init__(self, char_index):
		TypedField(MFString, MFString, SFString).__init__(self)
		self.char_index = char_index
		
	def update(self,event):
		routes_in = self.getRoutesIn()
		num_sfstrings = len(routes_in) - 1
		v = routes_in[0].getValue()
		
		# make sure our string_index is not off the end of the MFString array
		min_strings_required = num_sfstrings
		if (len(v) < min_strings_required):
			i = len(v)
			while i < min_strings_required:
			   v.append("")
			   i = i + 1

		if (event != routes_in[0]):
			# Find out which field caused the event
			fld_index = 0
			for field in (routes_in):
				if field == event:
					break
				fld_index = fld_index + 1
			string_index = fld_index - 1
			
			str = event.getValue()
			i = 0
			temp_str = v[string_index]
			new_str = ""
			while (i < self.char_index):
			   new_str += temp_str[i]
			   i = i+ 1
			for j in range(0, len(str)):
				new_str += str[j]
			v[string_index] = new_str
				
		return v
		
sfStringToMFString_0 = SFStringToMFString(0)
sfStringToMFString_1 = SFStringToMFString(0)
sfStringToMFString_4 = SFStringToMFString(4)


# This returns the first field (an MFString) modified with the contents of the 
# one of the other fields (SFString) - whichever has changed.
# It will modify the string of the MFString matching string_index supplied in the constructor
# Within this string, it will replace the characters starting at self.char_index
# It then returns the resulting string

class SFStringToOneOfMFString(TypedField(MFString, MFString, SFString)):
	def __init__(self, string_index, char_index):
		TypedField(MFString, MFString, SFString).__init__(self)
		self.char_index = char_index
		self.string_index = string_index
		
	def update(self,event):
		routes_in = self.getRoutesIn()
		v = routes_in[0].getValue()
		
		# make sure our string_index is not off the end of the MFString array
		min_strings_required = self.string_index + 1
		if (len(v) < min_strings_required):
			i = len(v)
			while i < min_strings_required:
			   v.append("")
			   i = i + 1
			
		if (event != routes_in[0]):
			#str = event.getValue()
			#i = 0
			#new_str = ""
			#while (i < self.char_index):
			#	new_str += v[self.string_index - 1][i]
			#	i = i+ 1
			#for j in range(0, len(str)):
			#	new_str += str[j]
			#v[self.string_index-1] = new_str
			
			str = event.getValue()
			i = 0
			temp_str = v[self.string_index]
			new_str = ""
			while (i < self.char_index):
			   new_str += temp_str[i]
			   i = i+ 1
			for j in range(0, len(str)):
				new_str += str[j]
			v[self.string_index] = new_str

		return v
		
sfStringToOneOfMFString_0_0 = SFStringToOneOfMFString(0, 0)
sfStringToOneOfMFString_0_3 = SFStringToOneOfMFString(0, 3)
sfStringToOneOfMFString_1_3 = SFStringToOneOfMFString(1, 3)
sfStringToOneOfMFString_0_8 = SFStringToOneOfMFString(0, 8)
sfStringToOneOfMFString_0_11 = SFStringToOneOfMFString(0, 11)
sfStringToOneOfMFString_0_12 = SFStringToOneOfMFString(0, 12)
sfStringToOneOfMFString_0_13 = SFStringToOneOfMFString(0, 13)
sfStringToOneOfMFString_0_14 = SFStringToOneOfMFString(0, 14)
sfStringToOneOfMFString_0_16 = SFStringToOneOfMFString(0, 16)
sfStringToOneOfMFString_0_23 = SFStringToOneOfMFString(0, 23)
sfStringToOneOfMFString_0_28 = SFStringToOneOfMFString(0, 28)

sfStringToOneOfMFString_1_0 = SFStringToOneOfMFString(1, 0)
