#
#File:      RemoteSFTest.py*
#Language:   C++ (header)
#Project:    H3DNetworkingUtils
#The contents of this file are subject to the Mozilla Public License
#Version 1.1 (the "License"); you may not use this file except in
#compliance with the License. You may obtain a copy of the License at
#http://www.mozilla.org/MPL/
 #
#Software distributed under the License is distributed on an "AS IS"
#basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
#License for the specific language governing rights and limitations
#under the License.
 #
#The Original Code is H3DNetworkingUtils v1.0.
#
#The Initial Developer of the Original Code is CSIRO.
#Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
#Contributor(s):
#    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
#-->

from H3DInterface import *

class BoolToFloat(TypedField(SFFloat, SFBool)):
   def __init__(self, true_val, false_val):
      TypedField(SFFloat, SFBool).__init__(self)
      self.true_val = true_val
      self.false_val = false_val
      
   def update( self, event ):
      if (event.getValue()):
			return self.true_val
      else:
			return self.false_val
boolToFloat_0_0_5 = BoolToFloat(0, 0.5)

class Vec2fToVec3f(TypedField(SFVec3f, SFVec2f)):
   def update( self, event ):
      v = event.getValue()
      return Vec3f(v.x, v.y, 0.0)

vec2Tovec3 = Vec2fToVec3f()

class Vec3fToVec2f(TypedField(SFVec2f, SFVec3f)):
   def __init__(self, scale):
      TypedField(SFVec2f, SFVec3f).__init__(self)
      self.scale = scale
   def update( self, event ):
      v = event.getValue()  * self.scale
      return Vec2f(v.x, v.y)

vec3Tovec2 = Vec3fToVec2f(1.0)

class PrintVec2f(AutoUpdate(SFVec2f)):
   def update( self, event ):
      v = event.getValue()
      print v
      return v

printVec2f = PrintVec2f()

class PrintVec3f(AutoUpdate(SFVec3f)):
   def update( self, event ):
      v = event.getValue()
      print v
      return v

printVec3f = PrintVec3f()

# This returns a 0 if x < 0 and a 1 if x > 0
class PosToInt(TypedField(SFInt32, SFVec3f)):
   def update( self, event ):
      v = event.getValue()
      if v.x < 0.0:
         return 0
      return 1

posToInt = PosToInt()

# This returns a RED if y < 0 and BLUE 1 if y > 0
class PosToColor(TypedField(SFColor, SFVec3f)):
   def update( self, event ):
      v = event.getValue()
      if v.y < 0.0:
         return RGB(1,0,0)
      return RGB(0,0,1)

posToColor = PosToColor()

# This returns a rotation about the given axis
class PosToRot(TypedField(SFRotation, SFVec3f)):
   def update( self, event ):
      axis = event.getValue()
      return Rotation(axis, 0.5)

posToRot = PosToRot()

# This returns the x value
class XVal(TypedField(SFFloat, SFVec3f)):
   def update( self, event ):
      axis = event.getValue()
      return axis.x

xVal = XVal()

class BoolToString(TypedField(SFString, SFBool)):
   def __init__(self, true_val, false_val):
      TypedField(SFString, SFBool).__init__(self)
      self.true_val = true_val
      self.false_val = false_val

   def update( self, event ):
      if (event.getValue()):
			return self.true_val
      else:
			return self.false_val
boolToString_on_off = BoolToString("on", "off")

class SFtoMFString(TypedField(MFString, SFString)):

   def update( self, event ):
      str = event.getValue()
      if len(str) == 0:
         str = "NULL"
      return [str]
sfToMFString = SFtoMFString()

class TimeToMFString(TypedField(MFString, SFTime)):
   def update( self, event ):
      t = event.getValue()
      return [str(t)]
timeToMFString = TimeToMFString()

class TimeToString(TypedField(SFString, SFTime)):
   def update( self, event ):
      t = event.getValue()
      return str(t)
timeToString = TimeToString()

class Shrinker(TypedField(SFVec2f, SFVec2f)):
   def update( self, event ):
      t = event.getValue()
      r = t / 50;
      return r
shrinker = Shrinker()

class Test(TypedField(SFVec3f, SFVec3f)):     
   def update( self, event ):
      return event.getValue()
test = Test()

class BoolToTime(AutoUpdate(TypedField(SFTime, SFBool))):      
   def update( self, event ):
      t0 = time.getValue()
      return t0
      
pressTime = BoolToTime()
