#
#File:      RemoteNormalVectorTest.py*
#Language:   C++ (header)
#Project:    H3DNetworkingUtils
#The contents of this file are subject to the Mozilla Public License
#Version 1.1 (the "License"); you may not use this file except in
#compliance with the License. You may obtain a copy of the License at
#http://www.mozilla.org/MPL/
 #
#Software distributed under the License is distributed on an "AS IS"
#basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
#License for the specific language governing rights and limitations
#under the License.
 #
#The Original Code is H3DNetworkingUtils v1.0.
#
#The Initial Developer of the Original Code is CSIRO.
#Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
#Contributor(s):
#    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
#-->

from H3DInterface import *
refs = references.getValue()
normal = refs[0]

class VecToMFVec3f(TypedField(MFVec3f, SFVec3f)):
   def __init__(self, scale):
      TypedField(MFVec3f, SFVec3f).__init__(self)
      self.scale = scale
      self.pts = normal.vector.getValue()
      self.p0 = self.pts[0]
      self.p1 = self.pts[2]
      self.p2 = self.pts[4]
      self.p3 = self.pts[6]
      self.p4 = self.pts[1]
      self.p5 = self.pts[3]
      self.p6 = self.pts[5]
      self.p7 = self.pts[7]
      print len(self.pts)
      
   def update( self, event ):
      v = event.getValue()
      v = v * self.scale
      v.z = 1 - v.x
      p0 = v
      p1 = v
      p2 = v
      p3 = v
      p4 = v
      p5 = v
      p6 = v
      p7 = v
      return [p0, p1, p2, p3, p4, p5, p6, p7]

vecToMFVec3f = VecToMFVec3f(4)

class BoolToMFInt32(TypedField(MFInt32, SFBool)):
   def update( self, event ):
      if event.getValue():
         return []
      else:
         return [2, 4, 5]

boolToMFInt32 = BoolToMFInt32()

class BoolToSFInt32(TypedField(SFInt32, SFBool)):
   def update( self, event ):
      if event.getValue():
         return 2
      else:
         return 2

boolToSFInt32 = BoolToSFInt32()

class Router(AutoUpdate(SFBool)):
   def __init__(self):
      AutoUpdate(SFBool).__init__(self)
      self.routed = 0
      self.first_event = 1

   def update( self, event ):
      b = event.getValue()
      # the first event from HDEV comes in before proxyposition has 
      # something sensible in it. So throw it away
      if self.first_event:
         self.first_event = 0
         return b
      if b:
         vecToMFVec3f.routeNoEvent(normal.vector)
         self.routed = 1
      else:
         if self.routed:
            vecToMFVec3f.unroute(normal.vector)
            self.routed = 0
      return b

router = Router()

