#
#File:      RemoteMFTest.py*
#Language:   C++ (header)
#Project:    H3DNetworkingUtils
#The contents of this file are subject to the Mozilla Public License
#Version 1.1 (the "License"); you may not use this file except in
#compliance with the License. You may obtain a copy of the License at
#http://www.mozilla.org/MPL/
 #
#Software distributed under the License is distributed on an "AS IS"
#basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
#License for the specific language governing rights and limitations
#under the License.
 #
#The Original Code is H3DNetworkingUtils v1.0.
#
#The Initial Developer of the Original Code is CSIRO.
#Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
#Contributor(s):
#    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
#

from H3DInterface import *
refs = references.getValue()
coord = refs[0]
colors = refs[1]

class VecToMFFloat(TypedField(MFFloat, SFVec3f)):
   def __init__(self, scale):
      TypedField(MFFloat, SFVec3f).__init__(self)
      self.scale = scale
      
   def update( self, event ):
      v = event.getValue()
      v = v * self.scale
      if v.x < 0.0:
         v.x = -v.x
      if v.y < 0.0:
         v.y = -v.y
      if v.z < 0.0:
         v.z = -v.z
      if v.x < 0.001:
         v.x = 0.001
      if v.y < 0.001:
         v.y = 0.001
      if v.z < 0.001:
         v.z = 0.001
      return[v.x, v.y, v.z]

vecToMFFloat = VecToMFFloat(1.0)

class VecToMFVec3f(TypedField(MFVec3f, SFVec3f)):
   def __init__(self, scale):
      TypedField(MFVec3f, SFVec3f).__init__(self)
      self.scale = scale
      self.pts = coord.point.getValue()
      print len(self.pts)
      
   def update( self, event ):
      p0 = self.pts[0]
      p1 = self.pts[1]
      p2 = self.pts[2]
      p3 = self.pts[3]
      p4 = self.pts[4]
      p5 = self.pts[5]
      v = event.getValue()
      v = v * self.scale
      p0.x = v.z
      p1.y = v.y
      p2.z = v.z
      p3.x = v.z
      p4.y = v.y
      p5.z = v.z
      return [p0, p1, p2, p3, p4, p5]

vecToMFVec3f = VecToMFVec3f(1.0)

class VecToMFColor(TypedField(MFColor, SFVec3f)):
   def __init__(self, scale):
      TypedField(MFColor, SFVec3f).__init__(self)
      self.scale = scale
      self.colors = colors.color.getValue()
      print len(self.colors)
      
   def update( self, event ):
      c0 = self.colors[0]
      c1 = self.colors[1]
      c2 = self.colors[2]
      c3 = self.colors[3]
      c4 = self.colors[4]
      c5 = self.colors[5]
      v = event.getValue()
      if v.x < 0:
         v.x = -v.x
      if v.y < 0:
         v.y = -v.y
      if v.z < 0:
         v.z = -v.z
      v = v * self.scale
      c0.r = v.x
      c1.g = v.y
      c2.b = v.z
      c3.g = v.x
      c3.g = v.x
      c4.r = v.y
      c4.g = v.y
      c5.r = v.z
      c5.b = v.z
      c5.g = v.z
      return [c0, c1, c2, c3, c4, c5]

vecToMFColor = VecToMFColor(6.0)

