from H3DInterface import *
dynA, dynB, dynC = references.getValue()

class Grab( TypedField(SFVec3f, SFVec3f, SFBool) ):
  def __init__(self, pos):
	 TypedField(SFVec3f, SFVec3f, SFBool).__init__(self)
	 self.default_pos = pos
	 
  def update( self, event):
	 routes = self.getRoutesIn()
	 pos = routes[0].getValue()
	 on = routes[1].getValue()
	 if on:
		return routes[0].getValue()
	 else:
		return self.default_pos
	    
grab = Grab(Vec3f(0, -0.08, 0))

class Wall (AutoUpdate(TypedField(SFVec3f, (SFVec3f, SFVec3f)))):
  def __init__(self, left, right, top, bottom, near, far, dyn):
	(AutoUpdate(TypedField(SFVec3f, (SFVec3f, SFVec3f)))).__init__(self)
	self.left = left
	self.right = right
	self.top = top
	self.bottom = bottom
	self.near = near
	self.far = far
	self.dyn = dyn
	
  def update(self, event):
    routes_in = self.getRoutesIn()
    pos = routes_in[0].getValue()
    mom = routes_in[1].getValue()
    if (pos.x < self.left):
       if (mom.x < 0):
          mom.x = -mom.x
    if (pos.x > self.right):
       if (mom.x > 0):
          mom.x = -mom.x
    if (pos.y < self.bottom):
       if (mom.y < 0):
          mom.y = -mom.y		
    if (pos.y > self.top):
       if (mom.y > 0):
          mom.y = -mom.y
    if (pos.z < self.far):
       if (mom.z < 0):
          mom.z = -mom.z		
    if (pos.z > self.near):
       if (mom.z > 0):
          mom.z = -mom.z
		
    self.dyn.momentum.setValue(mom)
    return mom

Awalls = Wall(-0.3, 0.3, 0.25, -0.25, 0.05, -0.05, dynA )
Bwalls = Wall(-0.3, 0.3, 0.25, -0.25, 0.05, -0.05, dynB )
Cwalls = Wall(-0.3, 0.3, 0.25, -0.25, 0.05, -0.05, dynC )