#
#File:      BufferedSfieldTest.py*
#Language:   C++ (header)
#Project:    H3DNetworkingUtils
#The contents of this file are subject to the Mozilla Public License
#Version 1.1 (the "License"); you may not use this file except in
#compliance with the License. You may obtain a copy of the License at
#http://www.mozilla.org/MPL/
 #
#Software distributed under the License is distributed on an "AS IS"
#basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
#License for the specific language governing rights and limitations
#under the License.
 #
#The Original Code is H3DNetworkingUtils v1.0.
#
#The Initial Developer of the Original Code is CSIRO.
#Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
#Contributor(s):
#    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
#

from H3DInterface import *
import time

class BoolToColor(TypedField(SFColor, SFBool)):
   def __init__(self, clr1, clr2):
      TypedField(SFColor, SFBool).__init__(self)
      self.clr1 = clr1
      self.clr2 = clr2
      
   def update( self, event ):
      if event.getValue():
         return self.clr1
      else:
         return self.clr2

boolToColor1 = BoolToColor(RGB(1,0,0), RGB(0,1,0))
boolToColor2 = BoolToColor(RGB(1,0,0), RGB(0,1,0))

class SFToMFString(TypedField(MFString, None, SFString)):
   def update(self, event):
      return [event.getValue()]

tcp_info_message = SFToMFString()

# Sleeps for a time to slow the frame rate
class FrameRateBrake(AutoUpdate(SFVec3f)):
   def __init__(self, delay):
      AutoUpdate(SFVec3f).__init__(self)
      self.delay = delay

   def update(self, event):
      time.sleep(self.delay)
      return event.getValue()

frameRateBrake = FrameRateBrake(0.4)
