#
#File:      BufferedMFieldTest.py*
#Language:   C++ (header)
#Project:    H3DNetworkingUtils
#The contents of this file are subject to the Mozilla Public License
#Version 1.1 (the "License"); you may not use this file except in
#compliance with the License. You may obtain a copy of the License at
#http://www.mozilla.org/MPL/
 #
#Software distributed under the License is distributed on an "AS IS"
#basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
#License for the specific language governing rights and limitations
#under the License.
 #
#The Original Code is H3DNetworkingUtils v1.0.
#
#The Initial Developer of the Original Code is CSIRO.
#Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
#Contributor(s):
#    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
#

from H3DInterface import *
import time

class BoolToStringSet(TypedField(MFString, SFBool)):
   def __init__(self, strs1, strs2):
      TypedField(MFString, SFBool).__init__(self)
      self.string_set1 = strs1
      self.string_set2 = strs2
      
   def update( self, event ):
      if event.getValue():
         return self.string_set1
      else:
         return self.string_set2

boolToStringSet = BoolToStringSet(["MFSTRING LINE 1", "MFSTRING LINE 2"], ["mfstring line 1", "mfstring line 2"])

class SFToMFString(TypedField(MFString, None, SFString)):
   def update(self, event):
      return [event.getValue()]

tcp_info_message = SFToMFString()

# Sleeps for a time to slow the frame rate
class FrameRateBrake(AutoUpdate(SFVec3f)):
   def __init__(self, delay):
      AutoUpdate(SFVec3f).__init__(self)
      self.delay = delay

   def update(self, event):
      time.sleep(self.delay)
      return event.getValue()

frameRateBrake = FrameRateBrake(0.4)
