/** \file
 * @brief  Include file for XID library
 * @author Elliot Duff esd@cat.csiro.au
 * 
 * XID 1.0   20 Oct 00 X11 Image Drawing Utilities 
 * XID 1.1   12 Jul 01 Add Select Window
 * XID 1.2   12 Jul 01 Add Select Window
 * XID 2.0   Have XID window handler.
 */

#ifndef _XID_H_    /* To prevent accidental re-inclusions */
#define _XID_H_

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifndef _XID_EXTERN             
#define _XID_EXTERN extern
#endif  
#endif  

_XID_EXTERN int xid_verbose;

#ifndef  DOXYGEN_SHOULD_SKIP_THIS
#define  FUNCPROTO 1
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Xmu/WinUtil.h>
#endif

typedef struct {
	char	*name;
	Window 	id;	    /*!< Window Indentifier */
	XImage *xi;    	    /*!< Current Image */
	GC     	gc;         /*!< Graphics Context */
	int    	w;     	    /*!< Window width */
	int    	h;          /*!< Window height */
	int    	l;     	    /*!< Window Increment per line */
	int 	sx;	    /*!< Starting Point of Image */
	int 	sy;
	int 	dx;	    /*!< Destination Point in Window */
	int 	dy;

	int 	redCmap[256];	/*!< Single Plane Color Map */
	int 	grnCmap[256];
	int 	bluCmap[256];
	int     redOver[256];	/*!< Overlay Color Map */
	int 	grnOver[256];
	int 	bluOver[256];
        } XIDwin; 

/* Open and Close the display */

#ifdef	__cplusplus
extern "C" {
#endif
int  XID_Open(char *display); 		/* Open connection to X server with display name */
void XID_Close(); 			/* Close Connection to X server */

/* Window Management  */

XIDwin *XID_WindowCreate(char *name, int w, int h, int x, int y, int b, int bs);
XIDwin *XID_WindowWithSize(int w, int h);	/* Grab window with matching size */
XIDwin *XID_WindowWithName(char *name);		/* Grab window with matching name */
XIDwin *XID_WindowWithMouse();			/* Grab window with Mouse click */
XIDwin *XID_WindowWithId(Window, int host);	/* Internal Function for creating Window Handler */

void XID_Destroy(XIDwin *);		/* Destroy Window and free memory */
void XID_Info(XIDwin *);		/* Print out information about window (for debugging) */

void XID_Raise(XIDwin *);		/* Raise Window to the top */
void XID_Lower(XIDwin *);		/* Lower Window to the top */
void XID_Rename(XIDwin *, char *name);	/* Change Name of window */
int  XID_LoadCmap(XIDwin *, char *filename, int overlay);	/* Load window Cmap from file using LIBSX environment */

/* Attributes */

void XID_SetColour(XIDwin *, int colour);
void XID_SetBGColour(XIDwin *, int colour);
int  XID_GetColour(XIDwin *, char *);
int  XID_GetRGBColour(XIDwin *, int, int, int);

/* Primitives */

void XID_DrawClear(XIDwin *);
void XID_DrawPixel(XIDwin *, int x, int y);
void XID_DrawMark(XIDwin *, int x, int y, int w);
void XID_DrawText(XIDwin *, char *s, int x, int y);
void XID_DrawLine(XIDwin *, int x1, int y1, int x2, int y2);
void XID_DrawBox(XIDwin *, int x, int y, int w, int h, int fill);
void XID_DrawArc(XIDwin *, int x, int y, int w, int h, int a, int b, int fill);

void XID_DrawImage(XIDwin *, unsigned char *ip, int nc, int nr);
void XID_DrawImageOver(XIDwin *, unsigned char *data, unsigned char *mask, int nc, int nr);
void XID_DrawImageRGB(XIDwin *, unsigned char *r, unsigned char *g, unsigned char *b, int nc, int nr);
void XID_DrawImageRGBI(XIDwin *, unsigned char *interleaved, int nc, int nr);
void XID_DrawImageRGBI_raw(XIDwin *, unsigned char *interleaved, int nc, int nr);

/* Event Handling */
int  XID_Event(char * s, int n);	/* Get an event (blocking) and store result in string */
int  XID_IfEvent(char *s, int n);
int  XID_GetEvent(char *s, int n);
int  XID_GetMouse(char *s);

#ifdef	__cplusplus
  }
#endif

#endif 
