/** \example demo.c
*
*/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "pip.h"
#include "xid.h"

#define XID_DrawPIP(w, i)     XID_DrawImage(w, i->data, i->nc, i->nr)
#define XID_DrawPIPOver(w, i) XID_DrawImageOver(w, i->data, i->mask, i->nc, i->nr)
#define XID_DrawRGB(w, i)     XID_DrawImageRGB(w, i[0]->data, i[1]->data, i[2]->data, i[0]->nc, i[0]->nr)

int main(int argc, char *argv[])
    {
    Pimage *grey;		/* Pointer to original PGM image */
    Pimage *rgb[3];		/* Pointer to original RGB image */
    Pimage *work;		/* Generic working image pointer */

    XIDwin *w1, *w2, *w3;	/* Window handlers */

    int  windowID;		/* Window identified by GetEvent */
    char event[40];		/* Buffer for event string */

    int x, y, b;		/* Mouse Coordinates */
    int xold=0,yold=0;		/* Old coordinates used in W2 */
    int green, yellow;		/* Colour Indexes */
    int toggle = 0;		

    /*
     * Load Images
     */

    grey   = PIP_new();
    work   = PIP_new();
    rgb[0] = PIP_new();
    rgb[1] = PIP_new();
    rgb[2] = PIP_new();

    if( PIP_load(grey, "Demo.gif") ) exit(-1); 			
    if( PIP_loadRGB(rgb, "Demo.jpg") ) exit(-1); 			

    /* 
     * Create a labelled image and use it as a mask
     * In PIP I still need to resolve some of the memory issues of doing this !
     */

    PIP_copy(work, grey);
    PIP_unary(work, '>', 128); 	/* Threshold Image */
    PIP_label(work, 4, 10, 1);  /* Label Image */
    grey->mask = work->data;	

    /* 
     * Make Connection to X server 
     */

    if( XID_Open("") ) exit(-1); 

    /* 
     * Create 3 window 
     */

    w1 = XID_WindowCreate("Window 1", grey->nc, grey->nr, 0, 0, 0, 0);
    w2 = XID_WindowCreate("Window 2", grey->nc, grey->nr, 0, 0, 0, 0);
    w3 = XID_WindowCreate("Window 3", rgb[0]->nc, rgb[0]->nr, 0, 0, 0, 0);

    /*
     * By default each window two colourmaps
     * One is for the data image, the other for the overlay. 
     * These colourmaps are ONLY used by DrawImage and DrawImageOver.
     * The colourmaps can be changed by modifying the XIDwin structure, 
     * or by using a function that looks in a directory defined by XID
     * The Colourmaps are not used by any other primitive including DrawRGBImage
     */

    XID_LoadCmap(w2, "rainbow", 0);	/* Load Rainbow file into the default (data) colourmap */
    XID_LoadCmap(w1, "regions", 1);	/* Load Regions file into the overlay (mask) colourmap */

    /* 
     * Get some colour for drawing line in Window 2 
     * These colour are unaffected by the choice of colourmap 
     */

    green = XID_GetColour(w2, "Green");
    yellow = XID_GetColour(w2, "Yellow");

    /*
     * Draw the image using macros compatible with PIP (See above)
     * These macros save typing in the components of the PIP structure
     */

    XID_DrawPIP(w1, grey);  
    XID_DrawPIP(w2, grey);
    XID_DrawRGB(w3, rgb);

    /* 
     * Demonstate GetEvent
     */

    printf("Click Mouse in Window\n");
    printf("In Window 1: Toggle Overlay Image \n");
    printf("In Window 2: Draw a line to the mouse release \n");
    printf("In Window 3: Draw grey scale image over RGB image \n");
    printf("Type [q] in any window to quit\n");

    while ( 1 ) {

      windowID = XID_GetEvent(event, 40);
      printf("Window %d Event (%s)\n", windowID, event);

      switch( event[0] ) {
	
	case 'q': 
          XID_Destroy(w1);
          XID_Destroy(w2);
          XID_Destroy(w3);
          XID_Close();
	  exit(0); 

	case 'B': /* This is a Mouse Button Event */

	  if( event[1] == 'P' ) break;  /* Ignore Press Event */

          sscanf(event, "%*s%d%d%d\n", &b,&x,&y);
          printf("Mouse %d %d %d\n", b,x,y);

          if( windowID == w1->id ) { 		/* Toggle Overlay plane */
	    toggle = !toggle; 
	    if( toggle ) XID_DrawPIPOver(w1, grey); 
	    else XID_DrawPIP(w1, grey);		   
	    }

          else if( windowID == w2->id ) {      /* Draw Line in different colours */
	    if( b == 1 ) XID_SetColour(w2, green);
	    else XID_SetColour(w2, yellow);
	    XID_DrawLine(w2, xold, yold, x, y); 
            xold = x; yold = y;
	    }

          else if( windowID == w3->id ) { 	/* Draw Grey image over RGB */
	    w3->dx = x; w3->dy = y; 
	    XID_DrawPIP(w3, grey); 
	    }

          else { printf("Unknown Window\n"); }
        }

      }
    }
