/**
 \example test-time.c

 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <stdio.h>
#include <errno.h>

#include "../include/rtx/time.h"

int
main (int argc, char * argv[])
{
	RtxTime	t1, t2, res;
	double	res_d;

	/* 5.6 - 2.2 = 3.4 */
	t1.seconds = 5;
	t1.nanoSeconds = 600000000;
	t2.seconds = 2;
	t2.nanoSeconds = 200000000;

	printf("%d.%09d - %d.%09d = %f\n", (int)t1.seconds, (int)t1.nanoSeconds, (int)t2.seconds, (int)t2.nanoSeconds, rtx_time_subtract_to_double(&t1, &t2));

	/* 5.2 - 2.6 =  2.6 */
	t1.seconds = 5;
	t1.nanoSeconds = 200000000;
	t2.seconds = 2;
	t2.nanoSeconds = 600000000;

	printf("%d.%09d - %d.%09d = %f\n", (int)t1.seconds, (int)t1.nanoSeconds, (int)t2.seconds, (int)t2.nanoSeconds, rtx_time_subtract_to_double(&t1, &t2));

	/* 2.2 - 5.6 = -3.4 */
	t1.seconds = 2;
	t1.nanoSeconds = 200000000;
	t2.seconds = 5;
	t2.nanoSeconds = 600000000;

	printf("%d.%09d - %d.%09d = %f\n", (int)t1.seconds, (int)t1.nanoSeconds, (int)t2.seconds, (int)t2.nanoSeconds, rtx_time_subtract_to_double(&t1, &t2));

	/* 2.4 - 4.2 = -1.8 */
	t1.seconds = 2;
	t1.nanoSeconds = 400000000;
	t2.seconds = 4;
	t2.nanoSeconds = 200000000;

	rtx_time_subtract(&res, &t1, &t2);
	res_d = (double)(res.nanoSeconds*1e-9);
	//res_d = (double)res.seconds+(double)(res.nanoSeconds*1e-9);
	printf("%d.%09d - %d.%09d = %d.%09d (%f)\n", (int)t1.seconds, (int)t1.nanoSeconds, (int)t2.seconds, (int)t2.nanoSeconds, (int)res.seconds, (int)res.nanoSeconds, res_d);

	return 1;
}

