/**
 \example test-threads2.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "../include/rtx/thread.h"
#include "../include/rtx/message.h"
#include "../include/rtx/error.h"
#include "../include/rtx/main.h"
#include "../include/rtx/time.h"
#include "../include/rtx/timer.h"
#include "../include/rtx/signal.h"
#include "../include/rtx/sem.h"

typedef struct _test_threads_arg {
  int thId;
  int useTimer;
  RtxTimer * tmr;
} TEST_THREADS_ARG;

static RtxSem * testSem;
RtxThread * ths;
TEST_THREADS_ARG thargs;

void * test_thread_func (TEST_THREADS_ARG * arg)
{
  rtx_message ("test_thread_func(%08X): start", (unsigned int)pthread_self());
  while (1) {
      sleep (1);
  }
  rtx_message ("test_thread_func(%08X): stop",(unsigned int)pthread_self());
  return (NULL);
}

int main (int argc, char * argv[])
{
  int i, numThreads = 10;
  char thname[128];
  int errs = 0;
  int useTimer = 0;

  if (argc > 1)
    useTimer = atoi (argv[1]);
  if (argc > 2)
    numThreads = atoi (argv[2]);

  rtx_message_init ("test_thread", RTX_MESSAGE_STDERR);

  rtx_message ("starting");

  if (rtx_error_init ("test_thread", RTX_ERROR_STDERR | RTX_ERROR_MESSAGE, NULL)) {
    perror ("main: rtx_error_init() failed: ");
    exit (1);
  }

  if ((testSem = rtx_sem_init (NULL, 0, 0)) == NULL) {
    rtx_error_flush ("main: rtx_sem_init() failed");
    exit (1);
  }

  if (rtx_signal_block_realtime () == -1) {
    rtx_error_flush ("main: rtx_signal_block_realtime() failed: ");
    exit (2);
  }

  rtx_message ("allocating memory");
  if ((ths = calloc (numThreads, sizeof (RtxThread *))) == NULL) {
    rtx_error_flush ("main: calloc() failed: ");
    exit (2);
  }
  
  rtx_message ("starting threads");
  i=0;
  while (1) {
      i += 1;
	
    sprintf (thname, "test_thread_func(%d)", i);
    thargs.thId = i;
    thargs.useTimer = useTimer;
    if ((ths = rtx_thread_create (thname,
				     1,
				     RTX_THREAD_SCHED_OTHER,
				     0,
				     0,
				     RTX_THREAD_CANCEL_ASYNCHRONOUS,
				     test_thread_func,
				     &(thargs),
				     NULL,
				     &(thargs))) == NULL) {
    /*
    if (rtx_thread_create_legacy (&(ths[i].id), 0, 0, test_thread_func,
				  &(thargs[i])) == -1) {
    */
      rtx_error ("main: rtx_thread_create(%d) failed", i);
      errs++;
    }
    //rtx_thread_detach(ths);
    rtx_message ("thread %d started", i);
    usleep(100000);
  }

  if (errs)
    rtx_error_traceback();
  rtx_message ("all threads up, waiting for shutdown");
  if (rtx_main_wait_shutdown (0) == -1)
    return (rtx_error ("main: rtx_main_init_shutdown() failed"));

}

