/**
 \example test-sync.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>

#include "../include/rtx/thread.h"
#include "../include/rtx/error.h"
#include "../include/rtx/message.h"
#include "../include/rtx/sync.h"
#include "../include/rtx/main.h"
#include "../include/rtx/signal.h"

RtxThread * w, * r1, * r2;
RtxSync * s;
int loopcount = 0;
int sleepDelay = 1000000;

void *
writer (
	void * arg
	)
{
    while (1) {
        loopcount++;
	if (rtx_sync_broadcast (s) == -1)
	    rtx_error_flush ("rtx_sync_broadcast");
	usleep (sleepDelay);
    }
}

void *
reader1 (
	 void * arg
	 )
{
    while (1) {
        if (rtx_sync_wait (s) == -1) {
	    rtx_error_flush ("rtx_sync_wait");
	    sleep (1);
	    continue;
	}
	if ((loopcount%2) == 0)
	    rtx_message ("reader1: %d\n", loopcount);
    }
}

void *
reader2 (
	 void * arg
	 )
{
    while (1) {
        if (rtx_sync_wait (s) == -1) {
	    rtx_error_flush ("rtx_sync_wait");
	    sleep (1);
	    continue;
	}
	if ((loopcount%2) == 1)
	    rtx_message ("reader2: %d\n", loopcount);
    }
}

int
main (
      int argc,
      char * argv[]
      )
{
    if (argc > 1)
        sleepDelay = atoi (argv[1]);

    rtx_main_init ("test-sync", RTX_ERROR_STDERR);
    rtx_message_init ("test-sync", RTX_MESSAGE_STDERR);
    if ((s = rtx_sync_init (NULL, RTX_MUTEX_DEFAULT, 0, RTX_MUTEX_DEFAULT)) == NULL)
        return (rtx_error ("rtx_sync_init() failed"));
    if ((w = rtx_thread_create ("writer", 0, RTX_THREAD_SCHED_OTHER, 0, 0, 
				RTX_THREAD_CANCEL_ASYNCHRONOUS, writer, NULL,
				NULL, NULL)) == NULL)
        return (rtx_error ("rtx_thread_create (writer) failed"));
    if ((r1 = rtx_thread_create ("reader1", 0, RTX_THREAD_SCHED_OTHER, 0, 0, 
				RTX_THREAD_CANCEL_ASYNCHRONOUS, reader1, NULL,
				NULL, NULL)) == NULL)
        return (rtx_error ("rtx_thread_create (reader1) failed"));
    if ((r2 = rtx_thread_create ("reader2", 0, RTX_THREAD_SCHED_OTHER, 0, 0, 
				RTX_THREAD_CANCEL_ASYNCHRONOUS, reader2, NULL,
				NULL, NULL)) == NULL)
        return (rtx_error ("rtx_thread_create (reader2) failed"));
    rtx_message ("running");
    rtx_main_wait_shutdown (0);
    rtx_message ("shutting down");
    if (rtx_thread_destroy (r1) == -1)
        rtx_error_flush ("rtx_thread_destroy (r1)");
    if (rtx_thread_destroy (r2) == -1)
        rtx_error_flush ("rtx_thread_destroy (r2)");
    if (rtx_thread_destroy (w) == -1)
        rtx_error_flush ("rtx_thread_destroy (w)");
    if (rtx_sync_destroy (s) == -1)
        rtx_error_flush ("rtx_sync_destroy ()");
    rtx_message ("done");
	return 0;
}
