/**
 \example test-serial.c
 * 
 * CSIRO Autonomous Systems Laboratory
 * Queensland Centre for Advanced Technologies
 * PO Box 883, Kenmore, QLD 4069, Australia
 * http://www.ict.csiro.au/
 *  
 * Copyright (c) CSIRO 
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../include/rtx/error.h"
#include "../include/rtx/message.h"
#include "../include/rtx/serial.h"
#include "../include/rtx/main.h"

int ttyfd = -1;
char devName[256] = "/dev/ttyS0";
int baudRate = -1;

int
main (int argc, char * argv[])
{
    if (argc > 1)
        strcpy (devName, argv[1]);
    if (argc > 2)
        baudRate = atoi (argv[2]);
    rtx_main_init ("test-serial", RTX_ERROR_STDERR);
    rtx_message_init ("test-serial", RTX_MESSAGE_STDERR);

    if ((ttyfd = rtx_serial_open (devName, baudRate, 8, 1, 
				  RTX_SERIAL_PARITY_NONE, 
				  RTX_SERIAL_FLOW_NONE,
				  RTX_SERIAL_MODEM_OFF,
				  1, 0)) == -1) {
        rtx_error_flush ("rtx_serial_open (%s)", devName);
	exit (1);
    }

    rtx_message ("serial port open");
    rtx_main_wait_shutdown (0);

    rtx_message ("shutting down");
    rtx_serial_close (ttyfd);
    return (0);
}

